/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms.helpers;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.Instruction;
import binnavi.plugins.gadgetfinder.algorithms.helpers.ReverseTreeWalkerCallback;
import binnavi.plugins.gadgetfinder.datastructures.helpers.InstructionHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressBlocksPathMap;
import binnavi.plugins.gadgetfinder.helper.Pair;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

class PathCollectorCallback
implements ReverseTreeWalkerCallback {
    private final AddressBlocksPathMap m_addressToPath = new AddressBlocksPathMap();
    private final int m_iterationDepth;
    private final Instruction m_startInstruction;
    private final LinkedHashSet<Long> m_specialInstructionAddresses;

    public PathCollectorCallback(int iterationDepth, Instruction startInstruction, LinkedHashSet<Long> specialInstructionAddresses) {
        this.m_iterationDepth = iterationDepth;
        this.m_startInstruction = startInstruction;
        this.m_specialInstructionAddresses = specialInstructionAddresses;
    }

    private Instruction getPreviousInstruction(List<BasicBlock> currentPath, Instruction currentInstruction) {
        BasicBlock currentBlock = currentPath.get(currentPath.size() - 1);
        List instructions = currentBlock.getInstructions();
        int index = instructions.indexOf(currentInstruction);
        if (index == instructions.size() - 1) {
            return currentPath.size() == 1 ? null : (Instruction)currentPath.get(currentPath.size() - 2).getInstructions().get(0);
        }
        return (Instruction)instructions.get(index + 1);
    }

    private List<BasicBlock> getPreviousPath(List<BasicBlock> currentPath, BasicBlock currentBasicBlock, Instruction currentInstruction) {
        List currentInstructions = currentBasicBlock.getInstructions();
        if (currentInstructions.indexOf(currentInstruction) == currentInstructions.size() - 1) {
            if (currentPath.size() == 1) {
                throw new IllegalStateException("Error: Should never happen");
            }
            return currentPath.subList(0, currentPath.size() - 1);
        }
        return new ArrayList<BasicBlock>(currentPath);
    }

    @Override
    public boolean call(List<BasicBlock> currentPath, BasicBlock currentBasicBlock, Instruction currentInstruction) {
        AbstractList path;
        boolean isStart;
        boolean bl = isStart = currentInstruction == this.m_startInstruction && currentPath.size() == 1;
        if ((InstructionHelper.isCallInstruction(currentInstruction) || !isStart && this.m_specialInstructionAddresses.contains(currentInstruction.getAddress().toLong())) && !InstructionHelper.isDynamicCallInstruction(currentInstruction)) {
            return false;
        }
        if (InstructionHelper.isUnknownInstruction(currentInstruction)) {
            return false;
        }
        Instruction previousInstruction = isStart ? null : this.getPreviousInstruction(currentPath, currentInstruction);
        AbstractList abstractList = path = previousInstruction == null ? new LinkedList() : new ArrayList<Long>(this.m_addressToPath.getPath(previousInstruction.getAddress().toLong(), this.getPreviousPath(currentPath, currentBasicBlock, currentInstruction)));
        if (path.size() == this.m_iterationDepth) {
            return false;
        }
        long currentAddress = currentInstruction.getAddress().toLong();
        path.add(0, currentAddress);
        this.m_addressToPath.put(new Pair<Long, List<BasicBlock>>(currentAddress, currentPath), new ArrayList<Long>(path));
        return true;
    }

    public AddressBlocksPathMap getTreemap() {
        return this.m_addressToPath;
    }
}

