/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.helpers;

import BinNavi.API.reil.OperandSize;
import BinNavi.API.reil.OperandType;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.enums.RegisterDataSourceType;
import binnavi.plugins.gadgetfinder.datastructures.helpers.ComparableReilOperandHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.LinkedBinaryTreeHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class GadgetTypeOperandTreeMapHelper {
    private static void calculateGadgetPostConditions(OperandTreeMap currentOperandTreeMap, ArrayList<Pair<Long, ComparableReilOperand>> stackFrame, ArrayList<ComparableReilOperand> nonStackFrame) {
        for (ComparableReilOperand currentOperandTreeMapKey : currentOperandTreeMap.keySet()) {
            if (!ComparableReilOperandHelper.isNativeRegister(currentOperandTreeMapKey) || currentOperandTreeMapKey.getElement().getValue().startsWith("MEM")) continue;
            LinkedBinaryTree<ComparableReilOperand> currentLinkedBinaryTree = currentOperandTreeMap.getTree(currentOperandTreeMapKey);
            Long currentStackFramePosition = GadgetTypeOperandTreeMapHelper.getRegisterStackFramePosition(currentLinkedBinaryTree);
            if (currentStackFramePosition != null) {
                stackFrame.add(new Pair<Long, ComparableReilOperand>(currentStackFramePosition, currentOperandTreeMapKey));
                continue;
            }
            nonStackFrame.add(currentOperandTreeMapKey);
        }
    }

    private static void calculateGadgetPreConditions(OperandTreeMap currentOperandTreeMap, Set<Pair<RegisterDataSourceType, ComparableReilOperand>> registersUsedInGadget) {
        for (ComparableReilOperand currentOperandTreeMapKey : currentOperandTreeMap.keySet()) {
            if (currentOperandTreeMapKey.getType() != OperandType.REGISTER) continue;
            LinkedBinaryTree<ComparableReilOperand> currentLinkedBinaryTree = currentOperandTreeMap.getTree(currentOperandTreeMapKey);
            if (currentOperandTreeMapKey.getValue().startsWith("COND")) {
                LinkedList<String> conditionExpression = LinkedBinaryTreeHelper.evaluateExpression(currentLinkedBinaryTree, currentLinkedBinaryTree.root());
                ComparableReilOperand conditionExpressionOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, conditionExpression.toString()));
                registersUsedInGadget.add(new Pair<RegisterDataSourceType, ComparableReilOperand>(RegisterDataSourceType.CONDITION, conditionExpressionOperand));
                continue;
            }
            if (currentOperandTreeMapKey.getValue().startsWith("MEM")) {
                for (Position<ComparableReilOperand> currentPosition : currentLinkedBinaryTree.positions()) {
                    if (currentPosition.element().getValue().equalsIgnoreCase("stm")) {
                        Position<ComparableReilOperand> stmLeftPosition = currentLinkedBinaryTree.left(currentPosition);
                        LinkedBinaryTree<ComparableReilOperand> leftSideSubtree = currentLinkedBinaryTree.buildSubtree(stmLeftPosition);
                        LinkedList<String> leftSide = LinkedBinaryTreeHelper.evaluateExpression(leftSideSubtree, stmLeftPosition);
                        ComparableReilOperand leftSideOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, leftSide.toString()));
                        if (leftSide.contains("ldm")) {
                            GadgetTypeOperandTreeMapHelper.checkForLDMinTree(currentLinkedBinaryTree, registersUsedInGadget);
                        } else {
                            registersUsedInGadget.add(new Pair<RegisterDataSourceType, ComparableReilOperand>(RegisterDataSourceType.REGISTER, leftSideOperand));
                        }
                        Position<ComparableReilOperand> stmRightPosition = currentLinkedBinaryTree.right(currentPosition);
                        LinkedBinaryTree<ComparableReilOperand> rightSideSubtree = currentLinkedBinaryTree.buildSubtree(stmRightPosition);
                        LinkedList<String> rightSide = LinkedBinaryTreeHelper.evaluateExpression(rightSideSubtree, stmRightPosition);
                        ComparableReilOperand rightSideOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, rightSide.toString()));
                        registersUsedInGadget.add(new Pair<RegisterDataSourceType, ComparableReilOperand>(RegisterDataSourceType.WRITE_VALID_MEMORY, rightSideOperand));
                        continue;
                    }
                    Position<ComparableReilOperand> tempPosition = currentPosition;
                    boolean continueCondition = false;
                    while (currentLinkedBinaryTree.hasParent(tempPosition)) {
                        if (!(tempPosition = currentLinkedBinaryTree.parent(tempPosition)).element().getValue().equalsIgnoreCase("stm")) continue;
                        continueCondition = true;
                        break;
                    }
                    if (!currentPosition.element().getType().equals((Object)OperandType.REGISTER) || !currentPosition.element().getValue().startsWith("R") || continueCondition) continue;
                    registersUsedInGadget.add(new Pair<RegisterDataSourceType, ComparableReilOperand>(RegisterDataSourceType.REGISTER, currentPosition.element()));
                }
                continue;
            }
            GadgetTypeOperandTreeMapHelper.registerTreeHandler(currentLinkedBinaryTree, registersUsedInGadget);
        }
    }

    private static void checkForLDMinTree(LinkedBinaryTree<ComparableReilOperand> currentLinkedBinaryTree, Set<Pair<RegisterDataSourceType, ComparableReilOperand>> registersUsedInGadget) {
        ComparableReilOperand ldmOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "ldm"));
        ArrayList<Position<ComparableReilOperand>> allLDMPositions = currentLinkedBinaryTree.find(ldmOperand);
        for (Position<ComparableReilOperand> position : allLDMPositions) {
            LinkedList<String> currentLDMExpression = LinkedBinaryTreeHelper.evaluateExpression(currentLinkedBinaryTree, currentLinkedBinaryTree.left(position));
            ComparableReilOperand currentLDMExpressionOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, currentLDMExpression.toString()));
            registersUsedInGadget.add(new Pair<RegisterDataSourceType, ComparableReilOperand>(RegisterDataSourceType.READ_VALID_MEMORY, currentLDMExpressionOperand));
        }
    }

    private static Long getRegisterStackFramePosition(LinkedBinaryTree<ComparableReilOperand> linkedBinaryTree) {
        ComparableReilOperand stackComparableReilOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "SP"));
        if (linkedBinaryTree.contains(stackComparableReilOperand)) {
            ArrayList<Position<ComparableReilOperand>> stackComparabelReilOperandPositions = linkedBinaryTree.find(stackComparableReilOperand);
            for (Position<ComparableReilOperand> position : stackComparabelReilOperandPositions) {
                Position<ComparableReilOperand> checkForLdmPosition;
                if (!linkedBinaryTree.isExternal(position) || !linkedBinaryTree.hasParent(position)) continue;
                Position<ComparableReilOperand> stackPointerParent = linkedBinaryTree.parent(position);
                String stackPointerParentValue = stackPointerParent.element().getValue();
                if (stackPointerParentValue.equalsIgnoreCase("ldm") && linkedBinaryTree.size() == 2) {
                    return 0L;
                }
                if (!stackPointerParentValue.equalsIgnoreCase("add")) continue;
                Position<ComparableReilOperand> siblingPosition = linkedBinaryTree.sibling(position);
                if (!linkedBinaryTree.hasParent(stackPointerParent) || !(checkForLdmPosition = linkedBinaryTree.parent(stackPointerParent)).element().getValue().equalsIgnoreCase("ldm") || !siblingPosition.element().getType().equals((Object)OperandType.INTEGER_LITERAL)) continue;
                return Long.parseLong(siblingPosition.element().getValue()) / 4L;
            }
        }
        return null;
    }

    private static String printGadgetConditions(OperandTreeMap operandTreeMap, Set<Pair<RegisterDataSourceType, ComparableReilOperand>> registersUsedInGadget, ArrayList<Pair<Long, ComparableReilOperand>> stackFrame, ArrayList<ComparableReilOperand> nonStackFrame) {
        String gadgetConditions = "";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[PRE CONDITIONS BEGIN]----\n";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[REGISTER USAGE BY TYPE]--\n";
        for (Pair<RegisterDataSourceType, ComparableReilOperand> pair : registersUsedInGadget) {
            gadgetConditions = String.valueOf(gadgetConditions) + "[i]-[TYPE]->> " + (Object)((Object)pair.first()) + " [" + pair.second() + "]";
        }
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[PRE CONDITIONS END]------\n";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[POST CONDITIONS BEGIN]---\n";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[ALL REGISTERS SET]-------\n";
        for (ComparableReilOperand comparableReilOperand : nonStackFrame) {
            gadgetConditions = String.valueOf(gadgetConditions) + "[i]-[" + comparableReilOperand + "]\n";
        }
        gadgetConditions = String.valueOf(gadgetConditions) + "\n";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[REGISTERS SET FROM STACK]\n";
        for (Pair pair : stackFrame) {
            gadgetConditions = String.valueOf(gadgetConditions) + "[i]-[STACK POSITION]-[" + pair.first() + "] => <<" + pair.second() + ">>\n";
        }
        gadgetConditions = String.valueOf(gadgetConditions) + "\n";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[CONTROL FLOW PASSED TO]--" + LinkedBinaryTreeHelper.evaluateExpression(operandTreeMap.getTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC"))), operandTreeMap.getTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC"))).root()) + "\n";
        gadgetConditions = String.valueOf(gadgetConditions) + "[i]---[POST CONDITIONS END]-----\n";
        return gadgetConditions;
    }

    private static void registerTreeHandler(LinkedBinaryTree<ComparableReilOperand> currentLinkedBinaryTree, Set<Pair<RegisterDataSourceType, ComparableReilOperand>> registersUsedInGadget) {
        GadgetTypeOperandTreeMapHelper.checkForLDMinTree(currentLinkedBinaryTree, registersUsedInGadget);
        for (Position<ComparableReilOperand> currentPosition : currentLinkedBinaryTree.positions()) {
            if (!currentPosition.element().getType().equals((Object)OperandType.REGISTER) || !currentPosition.element().getValue().startsWith("R")) continue;
            boolean hasLDMParent = false;
            Position<ComparableReilOperand> tempPosition = currentPosition;
            while (currentLinkedBinaryTree.hasParent(tempPosition)) {
                if (!(tempPosition = currentLinkedBinaryTree.parent(tempPosition)).element().getValue().equalsIgnoreCase("ldm")) continue;
                hasLDMParent = true;
            }
            if (hasLDMParent) continue;
            registersUsedInGadget.add(new Pair<RegisterDataSourceType, ComparableReilOperand>(RegisterDataSourceType.REGISTER, currentPosition.element()));
        }
    }

    public static String calculateGadgetPreAndPostCondition(OperandTreeMap currentOperandTreeMap) {
        HashSet<Pair<RegisterDataSourceType, ComparableReilOperand>> registersUsedInGadget = new HashSet<Pair<RegisterDataSourceType, ComparableReilOperand>>();
        ArrayList<Pair<Long, ComparableReilOperand>> stackFrame = new ArrayList<Pair<Long, ComparableReilOperand>>();
        ArrayList<ComparableReilOperand> nonStackFrame = new ArrayList<ComparableReilOperand>();
        GadgetTypeOperandTreeMapHelper.calculateGadgetPreConditions(currentOperandTreeMap, registersUsedInGadget);
        GadgetTypeOperandTreeMapHelper.calculateGadgetPostConditions(currentOperandTreeMap, stackFrame, nonStackFrame);
        return GadgetTypeOperandTreeMapHelper.printGadgetConditions(currentOperandTreeMap, registersUsedInGadget, stackFrame, nonStackFrame);
    }
}

