/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.helpers;

import BinNavi.API.disassembly.Instruction;
import BinNavi.API.disassembly.Operand;
import BinNavi.API.disassembly.OperandExpression;
import BinNavi.API.reil.InternalTranslationException;
import BinNavi.API.reil.ReilBlock;
import BinNavi.API.reil.ReilHelpers;
import BinNavi.API.reil.ReilInstruction;
import BinNavi.API.reil.ReilOperand;
import java.util.Iterator;

public class InstructionHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCallInstruction(Instruction currentInstruction) {
        try {
            Iterator iterator = currentInstruction.getReilCode().iterator();
            block2: while (true) {
                ReilInstruction reilInstruction;
                if (!iterator.hasNext()) {
                    return false;
                }
                ReilBlock reilBlock = (ReilBlock)iterator.next();
                Iterator iterator2 = reilBlock.getInstructions().iterator();
                do {
                    if (!iterator2.hasNext()) continue block2;
                } while (!ReilHelpers.isFunctionCall((ReilInstruction)(reilInstruction = (ReilInstruction)iterator2.next())));
                break;
            }
            return true;
        }
        catch (InternalTranslationException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDynamicCallInstruction(Instruction currentInstruction) {
        if (currentInstruction.getArchitecture().startsWith("ARM")) {
            if (currentInstruction.getMnemonic().startsWith("BX") && ((OperandExpression)((Operand)currentInstruction.getOperands().get(0)).getRootNode().getChildren().get(0)).getValue().startsWith("R")) {
                return true;
            }
            if (currentInstruction.getMnemonic().startsWith("BLX") && ((OperandExpression)((Operand)currentInstruction.getOperands().get(0)).getRootNode().getChildren().get(0)).getValue().startsWith("R")) {
                return true;
            }
            if (currentInstruction.getMnemonic().startsWith("POP") && currentInstruction.getMnemonic().length() > 3) {
                return true;
            }
            if (currentInstruction.getMnemonic().startsWith("LDM") && currentInstruction.getMnemonic().length() > 5) {
                return true;
            }
        }
        try {
            Iterator iterator = currentInstruction.getReilCode().iterator();
            block2: while (true) {
                ReilInstruction reilInstruction;
                if (!iterator.hasNext()) {
                    return false;
                }
                ReilBlock reilBlock = (ReilBlock)iterator.next();
                Iterator iterator2 = reilBlock.getInstructions().iterator();
                do {
                    if (!iterator2.hasNext()) continue block2;
                } while (!(reilInstruction = (ReilInstruction)iterator2.next()).getMnemonic().equalsIgnoreCase("JCC") || !ReilHelpers.isNativeRegister((ReilOperand)reilInstruction.getThirdOperand()));
                break;
            }
            return true;
        }
        catch (InternalTranslationException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUnknownInstruction(Instruction currentInstruction) {
        try {
            Iterator iterator = currentInstruction.getReilCode().iterator();
            block2: while (true) {
                ReilInstruction reilInstruction;
                if (!iterator.hasNext()) {
                    return false;
                }
                ReilBlock reilBlock = (ReilBlock)iterator.next();
                Iterator iterator2 = reilBlock.getInstructions().iterator();
                do {
                    if (!iterator2.hasNext()) continue block2;
                } while (!(reilInstruction = (ReilInstruction)iterator2.next()).getMnemonic().equalsIgnoreCase("UNKN") || !ReilHelpers.isNativeRegister((ReilOperand)reilInstruction.getThirdOperand()));
                break;
            }
            return true;
        }
        catch (InternalTranslationException e) {
            e.printStackTrace();
        }
        return false;
    }
}

