/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.helpers;

import BinNavi.API.reil.ReilHelpers;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.helpers.LinkedBinaryTreeHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import java.util.ArrayList;
import java.util.LinkedList;

public class OperandTreeMapHelper {
    public static boolean checkTreesForTemporaryRegisters(OperandTreeMap operandTreeMap) {
        for (LinkedBinaryTree<ComparableReilOperand> tree : operandTreeMap.getTrees()) {
            for (Position<ComparableReilOperand> position : tree.positions()) {
                if (!position.element().getValue().startsWith("t")) continue;
                System.out.println("[!] a temporary REIL operand is not valid in extracted operand tree for single native instruction");
                System.out.println("[!] position: " + position + " value" + position.element().getValue());
                return true;
            }
        }
        return false;
    }

    public static boolean checkTreeSize(OperandTreeMap operandTreeMap, int threshold) {
        for (ComparableReilOperand treeKey : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> currentTree = operandTreeMap.getTree(treeKey);
            if (currentTree.size <= threshold) continue;
            return false;
        }
        return true;
    }

    public static String printExpression(OperandTreeMap operandTreeMap) {
        String expressionString = "";
        for (ComparableReilOperand register : operandTreeMap.keySet()) {
            LinkedBinaryTree<ComparableReilOperand> tree = operandTreeMap.getTree(register);
            LinkedList<String> expressionList = LinkedBinaryTreeHelper.evaluateExpression(tree, tree.root());
            expressionString = String.valueOf(expressionString) + "Expression : " + register + "->";
            for (String reilOperand : expressionList) {
                expressionString = String.valueOf(expressionString) + " " + reilOperand;
            }
            expressionString = String.valueOf(expressionString) + "\n";
        }
        expressionString = String.valueOf(expressionString) + "---------------------------------------------------------";
        return expressionString;
    }

    public static void removeObsoleteTrees(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand comparableReilOperand : new ArrayList<ComparableReilOperand>(operandTreeMap.keySet())) {
            if (ReilHelpers.isReilRegister((String)comparableReilOperand.getValue())) {
                operandTreeMap.deleteTree(comparableReilOperand);
            }
            if (!comparableReilOperand.getValue().equalsIgnoreCase("TRUE") && !comparableReilOperand.getValue().equalsIgnoreCase("FALSE")) continue;
            operandTreeMap.deleteTree(comparableReilOperand);
        }
    }

    public static void restoreNativeRegisterNames(OperandTreeMap operandTreeMap) {
        for (ComparableReilOperand comparableReilOperand : new ArrayList<ComparableReilOperand>(operandTreeMap.keySet())) {
            if (!comparableReilOperand.getValue().contains("-OUT")) continue;
            LinkedBinaryTree<ComparableReilOperand> temp = operandTreeMap.deleteTree(comparableReilOperand);
            String newName = comparableReilOperand.getValue().replace("-OUT", "");
            ComparableReilOperand newComparableReilOperand = new ComparableReilOperand(new ReilOperand(comparableReilOperand.getSize(), newName));
            operandTreeMap.storeTree(newComparableReilOperand, temp);
        }
    }
}

