/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.helpers;

import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.helpers.OperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.PathOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.Pair;
import java.util.List;

public class PathOperandTreeHelper {
    public static boolean checkTreeSize(PathOperandTreeMap pathToOperandTreeMap, int threshold) {
        for (Pair<Long, List<Long>> key : pathToOperandTreeMap.keySet()) {
            if (OperandTreeMapHelper.checkTreeSize(pathToOperandTreeMap.get(key), threshold)) continue;
            return false;
        }
        return true;
    }

    public static void printExpression(PathOperandTreeMap pathToOperandTreeMap) {
        for (Pair<Long, List<Long>> mergedOperandTree : pathToOperandTreeMap.keySet()) {
            System.out.println("---------------------------------------------------------");
            System.out.println("Expressions for starting Address " + Long.toHexString(mergedOperandTree.first()) + " with Length " + mergedOperandTree.second().size());
            OperandTreeMap currentOperandTree = pathToOperandTreeMap.get(mergedOperandTree);
            OperandTreeMapHelper.printExpression(currentOperandTree);
        }
    }

    public static void printPathOperandTree(PathOperandTreeMap pathToOperandTreeMap) {
        for (Pair<Long, List<Long>> pathKey : pathToOperandTreeMap.keySet()) {
            System.out.println("[i] ADDRESS :: " + Long.toHexString(pathKey.first()));
            System.out.println("[i] PATH LENGTH :: " + pathKey.second().size());
            for (Long element : pathKey.second()) {
                System.out.println(Long.toHexString(element));
            }
            for (ComparableReilOperand value : pathToOperandTreeMap.get(pathKey).keySet()) {
                LinkedBinaryTree<ComparableReilOperand> currentExpressionTree = pathToOperandTreeMap.get(pathKey).getTree(value);
                System.out.println("[i] TREE :: " + value);
                currentExpressionTree.print(true, "", currentExpressionTree.root());
            }
            System.out.println("---------------------------------------------------");
        }
    }
}

