/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.list;

import binnavi.plugins.gadgetfinder.datastructures.helpers.ElementIterator;
import binnavi.plugins.gadgetfinder.datastructures.list.Interfaces.PositionList;
import binnavi.plugins.gadgetfinder.datastructures.node.DNode;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.helper.BoundaryViolationException;
import binnavi.plugins.gadgetfinder.helper.EmptyListException;
import binnavi.plugins.gadgetfinder.helper.InvalidPositionException;
import java.io.Serializable;
import java.util.Iterator;

public class NodePositionList<E>
implements PositionList<E>,
Serializable {
    private static final long serialVersionUID = 8074445712608338746L;
    protected int numElts = 0;
    protected DNode<E> header = new DNode<Object>(null, null, null);
    protected DNode<E> trailer = new DNode<Object>(this.header, null, null);

    public static <E> String forEachToString(PositionList<E> L) {
        String s = "[";
        int i = L.size();
        for (E elem : L) {
            s = String.valueOf(s) + elem;
            if (--i <= 0) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public static <E> String toString(PositionList<E> l) {
        Iterator<E> it = l.iterator();
        String s = "[";
        while (it.hasNext()) {
            s = String.valueOf(s) + it.next();
            if (!it.hasNext()) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public NodePositionList() {
        this.header.setNext(this.trailer);
    }

    protected DNode<E> checkPosition(Position<E> p) throws InvalidPositionException {
        if (p == null) {
            throw new InvalidPositionException("Null position passed to NodeList");
        }
        if (p == this.header) {
            throw new InvalidPositionException("The header node is not a valid position");
        }
        if (p == this.trailer) {
            throw new InvalidPositionException("The trailer node is not a valid position");
        }
        try {
            DNode temp = (DNode)p;
            if (temp.getPrev() == null || temp.getNext() == null) {
                throw new InvalidPositionException("Position does not belong to a valid NodeList");
            }
            return temp;
        }
        catch (ClassCastException e) {
            throw new InvalidPositionException("Position is of wrong type for this list");
        }
    }

    @Override
    public void addAfter(Position<E> p, E element) throws InvalidPositionException {
        DNode<E> v = this.checkPosition(p);
        ++this.numElts;
        DNode<E> newNode = new DNode<E>(v, v.getNext(), element);
        v.getNext().setPrev(newNode);
        v.setNext(newNode);
    }

    @Override
    public void addBefore(Position<E> p, E element) throws InvalidPositionException {
        DNode<E> v = this.checkPosition(p);
        ++this.numElts;
        DNode<E> newNode = new DNode<E>(v.getPrev(), v, element);
        v.getPrev().setNext(newNode);
        v.setPrev(newNode);
    }

    @Override
    public void addFirst(E element) {
        ++this.numElts;
        DNode<E> newNode = new DNode<E>(this.header, this.header.getNext(), element);
        this.header.getNext().setPrev(newNode);
        this.header.setNext(newNode);
    }

    @Override
    public void addLast(E element) {
        ++this.numElts;
        DNode<E> oldLast = this.trailer.getPrev();
        DNode<E> newNode = new DNode<E>(oldLast, this.trailer, element);
        oldLast.setNext(newNode);
        this.trailer.setPrev(newNode);
    }

    public boolean equals(PositionList<E> l) {
        if (l.first().element().equals(this.first().element()) && l.last().element().equals(this.last().element()) && this.size() == l.size()) {
            Position<E> currentThisPos = this.first();
            Position<E> currentCheckPos = l.first();
            int i = this.size();
            while (i > 0) {
                if (!currentThisPos.element().equals(currentCheckPos.element())) {
                    return false;
                }
                currentThisPos = currentThisPos == this.last() ? currentThisPos : this.next(currentThisPos);
                currentCheckPos = currentCheckPos == l.last() ? currentCheckPos : l.next(currentCheckPos);
                --i;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Position<E> first() throws EmptyListException {
        if (this.isEmpty()) {
            throw new EmptyListException("List is empty");
        }
        return this.header.getNext();
    }

    @Override
    public boolean isEmpty() {
        return this.numElts == 0;
    }

    public boolean isFirst(Position<E> p) throws InvalidPositionException {
        DNode<E> v = this.checkPosition(p);
        return v.getPrev() == this.header;
    }

    public boolean isLast(Position<E> p) throws InvalidPositionException {
        DNode<E> v = this.checkPosition(p);
        return v.getNext() == this.trailer;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator(this);
    }

    @Override
    public Position<E> last() throws EmptyListException {
        if (this.isEmpty()) {
            throw new EmptyListException("List is empty");
        }
        return this.trailer.getPrev();
    }

    @Override
    public Position<E> next(Position<E> p) throws InvalidPositionException, BoundaryViolationException {
        DNode<E> v = this.checkPosition(p);
        DNode<E> next = v.getNext();
        if (next == this.trailer) {
            throw new BoundaryViolationException("Cannot advance past the end of the list");
        }
        return next;
    }

    @Override
    public Iterable<Position<E>> positions() {
        NodePositionList<Position<Position<E>>> P = new NodePositionList<Position<Position<E>>>();
        if (!this.isEmpty()) {
            Position<E> p = this.first();
            while (true) {
                P.addLast(p);
                if (p == this.last()) break;
                p = this.next(p);
            }
        }
        return P;
    }

    @Override
    public Position<E> prev(Position<E> p) throws InvalidPositionException, BoundaryViolationException {
        DNode<E> v = this.checkPosition(p);
        DNode<E> prev = v.getPrev();
        if (prev == this.header) {
            throw new BoundaryViolationException("Cannot advance past the beginning of the list");
        }
        return prev;
    }

    @Override
    public E remove(Position<E> p) throws InvalidPositionException {
        DNode v = this.checkPosition(p);
        --this.numElts;
        DNode<E> vPrev = v.getPrev();
        DNode<E> vNext = v.getNext();
        vPrev.setNext(vNext);
        vNext.setPrev(vPrev);
        E vElem = v.element();
        v.setNext(null);
        v.setPrev(null);
        return vElem;
    }

    @Override
    public E set(Position<E> p, E element) throws InvalidPositionException {
        DNode<E> v = this.checkPosition(p);
        E oldElt = v.element();
        v.setElement(element);
        return oldElt;
    }

    @Override
    public int size() {
        return this.numElts;
    }

    public void swapElements(Position<E> a, Position<E> b) throws InvalidPositionException {
        DNode<E> pA = this.checkPosition(a);
        DNode<E> pB = this.checkPosition(b);
        E temp = pA.element();
        pA.setElement(pB.element());
        pB.setElement(temp);
    }

    public String toString() {
        return NodePositionList.toString(this);
    }
}

