/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.callresolver;

import BinNavi.API.debug.DebugException;
import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.CouldntLoadDataException;
import BinNavi.API.disassembly.CouldntSaveDataException;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.View;
import BinNavi.API.disassembly.View2D;
import BinNavi.API.helpers.Settings;
import BinNavi.API.plugins.PluginInterface;
import com.zynamics.binnavi.standardplugins.callresolver.CallResolver;
import com.zynamics.binnavi.standardplugins.callresolver.FontHelper;
import com.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.zynamics.binnavi.standardplugins.callresolver.OutputGraphGenerator;
import com.zynamics.binnavi.standardplugins.callresolver.OutputListGenerator;
import com.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public final class CallResolverDialog
extends JDialog {
    private static final long serialVersionUID = 681460634443519017L;
    private final IconPanel[] panels = new IconPanel[]{new IconPanel("1. Loading target"), new IconPanel("2. Find indirect calls"), new IconPanel("3. Start debugger", new ResumeButton()), new IconPanel("4. Set breakpoints"), new IconPanel("5. Resolving breakpoints"), new IconPanel("6. Stop call resolving")};
    private final JTextArea outputArea = new JTextArea();
    private final JButton listResolvedFunctionsButton = new JButton(new ListResolvedFunctionsAction());
    private final JButton graphResolvedFunctionsButton = new JButton(new GraphResolvedFunctionsAction());
    private final JButton portResultsButton = new JButton(new GraphAllFunctionsAction());
    private final NextAction nextAction = new NextAction();
    private final CallResolver callResolver;

    private CallResolverDialog(JFrame jFrame, ICallResolverTarget iCallResolverTarget) {
        super((Frame)jFrame, "Call Resolver");
        assert (jFrame != null);
        assert (iCallResolverTarget != null);
        this.callResolver = new InternalCallResolver(iCallResolverTarget, jFrame);
        this.setLayout(new BorderLayout());
        this.add((Component)new LabelPanel(), "North");
        this.add(new OutputPanel());
        this.add((Component)new ButtonPanel(), "South");
        this.setSize(700, 600);
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
        Settings.setShowDialogs((boolean)false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                CallResolverDialog.this.close();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CallResolverDialog.this.setVisible(false);
                CallResolverDialog.this.dispose();
            }
        });
        this.updateGui();
    }

    public static void show(JFrame jFrame, ICallResolverTarget iCallResolverTarget) {
        CallResolverDialog callResolverDialog = new CallResolverDialog(jFrame, iCallResolverTarget);
        callResolverDialog.setVisible(true);
    }

    private void appendOutput(String string) {
        this.outputArea.setText(this.outputArea.getText() + string + "\n");
        this.outputArea.setCaretPosition(this.outputArea.getDocument().getLength());
    }

    private void close() {
        Settings.setShowDialogs((boolean)true);
        this.callResolver.dispose();
        this.setVisible(false);
    }

    private void graphAllFunctions() {
        new Thread(){

            @Override
            public void run() {
                View view = OutputGraphGenerator.createCompleteView(CallResolverDialog.this.callResolver.getTarget(), CallResolverDialog.this.callResolver.getIndirectAddresses(), CallResolverDialog.this.callResolver.getResolvedAddresses());
                View2D view2D = PluginInterface.instance().showInLastWindow(view);
                view2D.doHierarchicalLayout();
                try {
                    view.save();
                }
                catch (CouldntSaveDataException couldntSaveDataException) {
                    couldntSaveDataException.printStackTrace();
                }
            }
        }.start();
    }

    private void graphResolvedFunctions() {
        new Thread(){

            @Override
            public void run() {
                View view = OutputGraphGenerator.createLoggedView(CallResolverDialog.this.callResolver.getTarget(), CallResolverDialog.this.callResolver.getIndirectAddresses(), CallResolverDialog.this.callResolver.getResolvedAddresses());
                View2D view2D = PluginInterface.instance().showInLastWindow(view);
                view2D.doHierarchicalLayout();
                try {
                    view.save();
                }
                catch (CouldntSaveDataException couldntSaveDataException) {
                    couldntSaveDataException.printStackTrace();
                }
            }
        }.start();
    }

    private void listResolvedFunctions() {
        this.outputArea.setText(OutputListGenerator.generate(this.callResolver.getResolvedAddresses()));
        this.outputArea.setCaretPosition(0);
    }

    private void updateGui() {
        int n = this.callResolver.getCurrentStep();
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].setEnabled(i <= n);
            this.panels[i].setDone(i < n);
        }
        this.listResolvedFunctionsButton.setEnabled(n == this.panels.length);
        this.graphResolvedFunctionsButton.setEnabled(n == this.panels.length);
        this.portResultsButton.setEnabled(n == this.panels.length);
        this.nextAction.putValue("Name", n == this.panels.length ? "Reset" : "Next");
    }

    private class ResumeButton
    extends JButton {
        private static final long serialVersionUID = 1366289398168399456L;

        public ResumeButton() {
            super(new ResumeAction());
            this.setPreferredSize(new Dimension(100, 20));
        }
    }

    private class ResumeAction
    extends AbstractAction {
        private static final long serialVersionUID = 8515011555579664301L;

        public ResumeAction() {
            super("Resume");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CallResolverDialog.this.callResolver.getTarget().getDebugger().resume();
            }
            catch (DebugException debugException) {
                CallResolverDialog.this.appendOutput(String.format("Error: Could not resume the debugger (%s)", debugException.toString()));
            }
        }
    }

    private class OutputPanel
    extends JPanel {
        private static final long serialVersionUID = 5695531504690157553L;

        public OutputPanel() {
            super(new BorderLayout());
            CallResolverDialog.this.outputArea.setEditable(false);
            CallResolverDialog.this.outputArea.setFont(new Font(FontHelper.getMonospaceFont(), 0, 12));
            this.add(new JScrollPane(CallResolverDialog.this.outputArea));
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = -6634525090724883966L;

        public NextAction() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CallResolverDialog.this.callResolver.next();
            CallResolverDialog.this.updateGui();
        }
    }

    private class ListResolvedFunctionsAction
    extends AbstractAction {
        private static final long serialVersionUID = -1774380530487978640L;

        public ListResolvedFunctionsAction() {
            super("Show resolved functions");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CallResolverDialog.this.listResolvedFunctions();
        }
    }

    private class LabelPanel
    extends JPanel {
        private static final long serialVersionUID = -5165347734655599830L;

        public LabelPanel() {
            super(new GridLayout(CallResolverDialog.this.panels.length + 1, 1));
            for (IconPanel iconPanel : CallResolverDialog.this.panels) {
                this.add(iconPanel);
            }
            JPanel jPanel = new JPanel();
            jPanel.add(CallResolverDialog.this.listResolvedFunctionsButton);
            jPanel.add(CallResolverDialog.this.graphResolvedFunctionsButton);
            jPanel.add(CallResolverDialog.this.portResultsButton);
            this.add(jPanel);
            this.setBorder(new TitledBorder(""));
        }
    }

    private class InternalCallResolver
    extends CallResolver {
        public InternalCallResolver(ICallResolverTarget iCallResolverTarget, JFrame jFrame) {
            super(iCallResolverTarget, jFrame);
        }

        @Override
        protected void debuggerChanged() {
            CallResolverDialog.this.appendOutput("Error: Target debugger changed. Resetting.");
            CallResolverDialog.this.updateGui();
        }

        @Override
        protected void debuggerClosed() {
            CallResolverDialog.this.appendOutput("Target debugger was closed.");
            CallResolverDialog.this.updateGui();
        }

        @Override
        protected void errorConnectingDebugger(DebugException debugException) {
            CallResolverDialog.this.appendOutput("Error: Could not start the debugger.");
        }

        @Override
        protected void errorLoadingModule(Module module, CouldntLoadDataException couldntLoadDataException) {
            CallResolverDialog.this.appendOutput(String.format("Error loading module '%s' (%s)", module.getName(), couldntLoadDataException.getMessage()));
        }

        @Override
        protected void errorNoDebugger() {
            CallResolverDialog.this.appendOutput("Error: No debugger configured for the selected target.");
        }

        @Override
        protected void errorNotAttached() {
            CallResolverDialog.this.appendOutput("Error: The debugger is not attached to the target process.");
        }

        @Override
        protected void errorResuming(DebugException debugException) {
            CallResolverDialog.this.appendOutput("Error: Debugger could not be resumed after a breakpoint was hit.");
        }

        @Override
        protected void foundIndirectCallAddresses(List<IndirectCall> list) {
            CallResolverDialog.this.appendOutput(String.format("Found %d indirect calls", list.size()));
            if (list.isEmpty()) {
                CallResolverDialog.this.appendOutput("No indirect function calls found: The resolving process is complete");
            }
        }

        @Override
        protected void resolvedCall(BigInteger bigInteger, ResolvedFunction resolvedFunction) {
            Function function = resolvedFunction.getFunction();
            Address address = function == null ? resolvedFunction.getAddress() : function.getAddress();
            String string = function == null ? resolvedFunction.getMemoryModule().getName() + "!???" : function.getModule().getName() + "!" + function.getName();
            CallResolverDialog.this.appendOutput(String.format("Done resolving: %08X -> %08X (%s)", bigInteger.longValue(), address.toLong(), string));
        }
    }

    private static class IconPanel
    extends JPanel {
        private static final long serialVersionUID = 7421239754522375627L;
        private final JLabel textLabel;
        private JComponent additionalComponent;
        private static ImageIcon ACCEPT_IMAGE;
        private static ImageIcon BULLET_IMAGE;

        public IconPanel(String string) {
            this(string, null);
        }

        public IconPanel(String string, JComponent jComponent) {
            super(new BorderLayout());
            if (ACCEPT_IMAGE == null) {
                try {
                    ACCEPT_IMAGE = new ImageIcon(CallResolverDialog.class.getResource("accept.png").toURI().toURL());
                    BULLET_IMAGE = new ImageIcon(CallResolverDialog.class.getResource("bullet_blue.png").toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            }
            this.textLabel = new JLabel(string);
            this.textLabel.setEnabled(false);
            this.add(this.textLabel);
            if (jComponent != null) {
                this.additionalComponent = jComponent;
                this.add((Component)jComponent, "East");
            }
            this.setPreferredSize(new Dimension(200, 20));
        }

        public void setDone(boolean bl) {
            this.textLabel.setIcon(bl ? ACCEPT_IMAGE : BULLET_IMAGE);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (this.additionalComponent != null) {
                this.additionalComponent.setEnabled(bl);
            }
            this.textLabel.setEnabled(bl);
        }
    }

    private class GraphResolvedFunctionsAction
    extends AbstractAction {
        private static final long serialVersionUID = 7223700633526132068L;

        public GraphResolvedFunctionsAction() {
            super("Create limited call graph view");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CallResolverDialog.this.graphResolvedFunctions();
        }
    }

    private class GraphAllFunctionsAction
    extends AbstractAction {
        private static final long serialVersionUID = -2039442533910414518L;

        public GraphAllFunctionsAction() {
            super("Create complete call graph view");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CallResolverDialog.this.graphAllFunctions();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -5992345766044009398L;

        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CallResolverDialog.this.close();
        }
    }

    private class ButtonPanel
    extends JPanel {
        private static final long serialVersionUID = -1493675785194378107L;

        public ButtonPanel() {
            super(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)new JButton(CallResolverDialog.this.nextAction), "West");
            jPanel.add((Component)new JButton(new CancelAction()), "East");
            this.add((Component)jPanel, "East");
        }
    }
}

