/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.coverage;

import BinNavi.API.debug.Debugger;
import BinNavi.API.gui.GraphFrame;
import BinNavi.API.helpers.MessageBox;
import com.zynamics.binnavi.standardplugins.coverage.IVisualCoverageListener;
import com.zynamics.binnavi.standardplugins.coverage.VisualCoverage;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public final class VisualCoverageAction
extends AbstractAction {
    private static final long serialVersionUID = 1511963098319768357L;
    private GraphFrame graphFrame;
    private VisualCoverage coverage = null;
    private final IVisualCoverageListener traceListener = new InternalTraceListener();

    public VisualCoverageAction(GraphFrame graphFrame) {
        super("Visual Coverage");
        this.graphFrame = graphFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = null;
        if (this.coverage != null) {
            MessageBox.showInformation(jFrame, (String)"Visual Coverage trace is already active");
            return;
        }
        List list = this.graphFrame.getDebuggers();
        if (list.size() == 0) {
            MessageBox.showInformation(jFrame, (String)"Visual Coverage trace can not be started because no debugger is configured for this graph.");
            return;
        }
        if (list.size() != 1) {
            MessageBox.showInformation(jFrame, (String)"Visual Coverage trace can not be started because more than one debugger is configured for this graph.");
            return;
        }
        Debugger debugger = (Debugger)list.get(0);
        this.coverage = new VisualCoverage(jFrame, debugger, this.graphFrame.getView2D());
        this.coverage.addListener(this.traceListener);
    }

    public void dispose() {
        if (this.coverage != null) {
            this.coverage.removeListener(this.traceListener);
            this.coverage.dispose();
            this.coverage = null;
            this.graphFrame = null;
        }
    }

    public GraphFrame getFrame() {
        return this.graphFrame;
    }

    private class InternalTraceListener
    implements IVisualCoverageListener {
        private InternalTraceListener() {
        }

        @Override
        public void finishedCoverage() {
            VisualCoverageAction.this.coverage.removeListener(VisualCoverageAction.this.traceListener);
            VisualCoverageAction.this.coverage = null;
        }
    }
}

