/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.pathfinder;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.CouldntLoadDataException;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.FunctionListenerAdapter;
import BinNavi.API.disassembly.IFunctionListener;
import BinNavi.API.helpers.IProgressThread;
import BinNavi.API.helpers.Logger;
import BinNavi.API.helpers.MessageBox;
import BinNavi.API.helpers.ProgressDialog;
import com.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeBlockNode;
import com.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeNode;
import com.zynamics.binnavi.standardplugins.pathfinder.IFunctionTreeNode;
import com.zynamics.binnavi.standardplugins.pathfinder.PathfinderPlugin;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public final class FunctionTreeFunctionNode
extends FunctionTreeNode
implements IFunctionTreeNode {
    private static final long serialVersionUID = -6902726801862349634L;
    private static final ImageIcon ICON_FUNCTION_LOADED = new ImageIcon(PathfinderPlugin.class.getResource("resources/graph2.png"));
    private static final ImageIcon ICON_FUNCTION_CLOSED = new ImageIcon(PathfinderPlugin.class.getResource("resources/graph2_gray.png"));
    private final JDialog m_parent;
    private final Function m_function;
    private final InternalFunctionListener m_listener = new InternalFunctionListener();

    public FunctionTreeFunctionNode(JDialog jDialog, Function function) {
        this.m_function = function;
        this.m_parent = jDialog;
        this.createBlockNodes();
        function.addListener((IFunctionListener)this.m_listener);
        this.updateIcon();
    }

    private void createBlockNodes() {
        if (this.m_function.isLoaded()) {
            List list = this.m_function.getGraph().getNodes();
            for (BasicBlock basicBlock : list) {
                this.add(new FunctionTreeBlockNode(basicBlock));
            }
        }
    }

    private void updateIcon() {
        this.setIcon(this.m_function.isLoaded() ? ICON_FUNCTION_LOADED : ICON_FUNCTION_CLOSED);
    }

    public void dispose() {
        this.m_function.removeListener((IFunctionListener)this.m_listener);
    }

    @Override
    public void doubleClicked() {
        if (!this.m_function.isLoaded()) {
            ProgressDialog.show((Window)this.m_parent, (String)"Loading Function", (IProgressThread)new IProgressThread(){

                public boolean close() {
                    return false;
                }

                public void run() {
                    try {
                        FunctionTreeFunctionNode.this.m_function.load();
                    }
                    catch (CouldntLoadDataException couldntLoadDataException) {
                        Logger.logException((Exception)((Object)couldntLoadDataException));
                        MessageBox.showException((Component)FunctionTreeFunctionNode.this.m_parent, (Exception)((Object)couldntLoadDataException), (String)"Function could not be loaded.");
                    }
                }
            });
        }
    }

    public Function getFunction() {
        return this.m_function;
    }

    @Override
    public boolean isVisible() {
        return this.getFilter() == null || this.getFilter().matchesFilter(this.m_function.getName());
    }

    @Override
    public String toString() {
        return this.m_function.getName();
    }

    private class InternalFunctionListener
    extends FunctionListenerAdapter {
        private InternalFunctionListener() {
        }

        public void loadedFunction(Function function) {
            FunctionTreeFunctionNode.this.updateIcon();
            FunctionTreeFunctionNode.this.createBlockNodes();
        }
    }
}

