/*
 * Decompiled with CFR 0.152.
 */
package com.zynamics.binnavi.standardplugins.pathfinder;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.Instruction;
import BinNavi.API.disassembly.Module;
import BinNavi.API.helpers.Logger;
import com.zynamics.binnavi.standardplugins.pathfinder.FilteredTreeModel;
import com.zynamics.binnavi.standardplugins.pathfinder.FunctionTree;
import com.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeBlockNode;
import com.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeFunctionNode;
import com.zynamics.binnavi.standardplugins.pathfinder.TextPatternFilter;
import com.zynamics.binnavi.standardplugins.utils.CDialogEscaper;
import com.zynamics.binnavi.standardplugins.utils.CPanelTwoButtons;
import com.zynamics.binnavi.standardplugins.utils.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;

public final class PathfindingDialog
extends JDialog {
    private static final long serialVersionUID = 2576130035120024801L;
    private final FunctionTree startBlockTree;
    private final FunctionTree endBlockTree;
    private Function startFunction;
    private Function endFunction;
    private BasicBlock startBlock;
    private BasicBlock endBlock;
    private boolean wasCancelled = true;
    private final InternalListener m_listener = new InternalListener();

    public PathfindingDialog(JFrame jFrame, Module module) {
        super(jFrame, "Pathfinding", true);
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.startBlockTree = new FunctionTree(this, module);
        this.endBlockTree = new FunctionTree(this, module);
        JTextArea jTextArea = this.createAsmField();
        JTextArea jTextArea2 = this.createAsmField();
        JTextArea jTextArea3 = new JTextArea(1, 10);
        JTextArea jTextArea4 = new JTextArea(1, 10);
        jTextArea3.getDocument().addDocumentListener(new InternalDocumentListener(this.startBlockTree));
        jTextArea4.getDocument().addDocumentListener(new InternalDocumentListener(this.endBlockTree));
        this.startBlockTree.addTreeSelectionListener(new InternalTreeSelectionListener(jTextArea));
        this.endBlockTree.addTreeSelectionListener(new InternalTreeSelectionListener(jTextArea2));
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(jTextArea3), new JScrollPane(jTextArea4));
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(1, true, new JScrollPane(this.startBlockTree), new JScrollPane(this.endBlockTree));
        jSplitPane2.setResizeWeight(0.5);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(jSplitPane2);
        jPanel2.add((Component)jSplitPane, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JSplitPane jSplitPane3 = new JSplitPane(1, true, new JScrollPane(jTextArea), new JScrollPane(jTextArea2));
        jSplitPane3.setResizeWeight(0.5);
        jPanel3.add(jSplitPane3);
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add(jPanel2);
        jSplitPane2.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
        this.add((Component)new CPanelTwoButtons(this.m_listener, "OK", "Cancel"), "South");
        this.setPreferredSize(new Dimension(800, 500));
        this.pack();
    }

    private JTextArea createAsmField() {
        JTextArea jTextArea = new JTextArea(10, 30);
        jTextArea.setFont(new Font(GuiHelper.getMonospaceFont(), 0, 12));
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public BasicBlock getEndBlock() {
        return this.endBlock;
    }

    public Function getEndFunction() {
        return this.endFunction;
    }

    public BasicBlock getStartBlock() {
        return this.startBlock;
    }

    public Function getStartFunction() {
        return this.startFunction;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private static class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private final JTextArea m_field;

        public InternalTreeSelectionListener(JTextArea jTextArea) {
            this.m_field = jTextArea;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof FunctionTreeBlockNode) {
                FunctionTreeBlockNode functionTreeBlockNode = (FunctionTreeBlockNode)object;
                BasicBlock basicBlock = functionTreeBlockNode.getBasicBlock();
                StringBuilder stringBuilder = new StringBuilder("");
                for (Instruction instruction : basicBlock.getInstructions()) {
                    stringBuilder.append(instruction.toString() + "\n");
                }
                this.m_field.setText(stringBuilder.toString());
                this.m_field.setCaretPosition(0);
            } else {
                this.m_field.setText("");
            }
        }
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        private BasicBlock getSelectedBlock(FunctionTree functionTree) {
            TreePath treePath = functionTree.getSelectionPath();
            if (treePath == null) {
                return null;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof FunctionTreeBlockNode) {
                return ((FunctionTreeBlockNode)object).getBasicBlock();
            }
            return null;
        }

        private Function getSelectedFunction(FunctionTree functionTree) {
            TreePath treePath = functionTree.getSelectionPath();
            if (treePath == null) {
                return null;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof FunctionTreeFunctionNode) {
                return ((FunctionTreeFunctionNode)object).getFunction();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("OK")) {
                PathfindingDialog.this.startBlock = this.getSelectedBlock(PathfindingDialog.this.startBlockTree);
                PathfindingDialog.this.endBlock = this.getSelectedBlock(PathfindingDialog.this.endBlockTree);
                PathfindingDialog.this.startFunction = this.getSelectedFunction(PathfindingDialog.this.startBlockTree);
                PathfindingDialog.this.endFunction = this.getSelectedFunction(PathfindingDialog.this.endBlockTree);
                PathfindingDialog.this.wasCancelled = false;
            }
            PathfindingDialog.this.startBlockTree.dispose();
            PathfindingDialog.this.endBlockTree.dispose();
            PathfindingDialog.this.dispose();
        }
    }

    private static class InternalDocumentListener
    implements DocumentListener {
        private final JTree m_tree;

        public InternalDocumentListener(JTree jTree) {
            this.m_tree = jTree;
        }

        private void updateTreeModel(DocumentEvent documentEvent) {
            try {
                String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                FilteredTreeModel filteredTreeModel = (FilteredTreeModel)this.m_tree.getModel();
                filteredTreeModel.setFilter(new TextPatternFilter(string));
            }
            catch (BadLocationException badLocationException) {
                Logger.logException((Exception)badLocationException);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateTreeModel(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateTreeModel(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateTreeModel(documentEvent);
        }
    }
}

