#ifndef SOCKETCONNECTION_H
#define SOCKETCONNECTION_H

#include "BaseConnection.hpp"

/**
* Base class for all socket connection policies.
**/
class SocketConnection : public BaseConnection
{
	private:
	
		/**
		* Port on which the debug client listens for BinNavi connections.
		**/
		unsigned int port;
		
	protected:
	
		/**
		* Returns the port on which the debug client listens for BinNavi connections.
		*
		* @return The port on which the debug client listens for BinNavi connections.
		**/
		unsigned int getPort() const { return port; }
		
		/**
		* Binds a socket to the port on which the debug client listens for BinNavi connections.
		
		* @return A NaviError code that describes whether the operation was successful or not.
		**/
		virtual NaviError bindSocket() = 0;
		
		/**
		* Closes the socket to BinNavi
		*
		* @return A NaviError code that describes whether the operation was successful or not.
		**/
		virtual NaviError closeSocket() = 0;
		
	public:
	
		/**
		* Creates a new socket connection policy.
		*
		* @param port The port on which the debug client listens for BinNavi connections.
		**/
		SocketConnection(unsigned int port) : port(port) { }
		
		//! Initializes the connection to BinNavi
		NaviError initializeConnection();
		
		//! Closes the connection to BinNavi
		NaviError closeConnection();
		
		virtual void printIpAddress() = 0;
};

#endif
