#ifdef NAVI_GDB_WINDOWS

#ifndef SERIALTRANSPORT_HPP
#define SERIALTRANSPORT_HPP

#include <windows.h>
#include <string>

#include "Transport.hpp"

/**
* Class that is used to communicate with the GDB server via a COM port.
**/
class SerialTransport : public Transport
{
	private:
	
		//! Handle of the COM port
		HANDLE port;
		
		//! String name of the COM port
		const std::string comport;
		
		//! Bauds that are supported by the COM port
		const unsigned int bauds;
		
	public:
	
		/**
		* Creates a new SerialTransport object.
		*
		* @param comport The name of the COM port.
		* @param bauds The number of bauds supported by the COM port.
		**/
		SerialTransport(const std::string& comport, unsigned int bauds) : comport(comport), bauds(bauds) { }
		
		//! Opens the COM port to the GDB server.
		NaviError open();
		
		//! Closes the COM port to the GDB server.
		NaviError close();
		
		//! Checks whether data is available on the GDB server.
		bool hasData() const;
		
		//! Sends data to the GDB server.
		NaviError send(const char* buffer, unsigned int size) const;
		
		//! Reads data from the GDB server.
		NaviError read(char* buffer, unsigned int size) const;
};

#endif
#endif