#ifndef TRANSPORT_HPP
#define TRANSPORT_HPP

#define NOMINMAX

#include "../errors.hpp"

/**
* Base class for various options to communicate with the gdbserver.
**/
class Transport
{
	public:
		/**
		* Opens the connection.
		**/
		virtual NaviError open() = 0;
		
		/**
		* Closes the connection.
		**/
		virtual NaviError close() = 0;
	
		/**
		* Determines whether data from gdbserver is available.
		*
		* @return True, if data is available. False, otherwise.
		**/
		virtual bool hasData() const = 0;
		
		/**
		* Sends data to the gdbserver.
		*
		* @param buffer The data to send.
		* @param size The size of the data in bytes.
		**/
		virtual NaviError send(const char* buffer, unsigned int size) const = 0;
		
		/**
		* Reads data from the gdbserver.
		*
		* @param buffer Buffer where the data from gdbserver is written to.
		* @param size Number of bytes to read from gdbserver.
		**/
		virtual NaviError read(char* buffer, unsigned int size) const = 0;
		
		virtual ~Transport() { }
};

#endif
