#ifndef UTILS_HPP
#define UTILS_HPP

#include <string>
#include <vector>
#include "../defs.hpp"

//! A macro that prints an error message and returns from a function if an operation failed
#define HANDLE_NAVI_ERROR(cmd, msg) { NaviError result = cmd; if (result) { msglog->log(LOG_ALWAYS, msg, result); return result; } }

//! Turns a GDB command into a GDB command packet
std::string packetify(const std::string& command);

//! Turns a GDB command packet into a gdb command
std::string unpacketify(const std::string& command);

//! Calculates the checksum of a GDB command
unsigned char checksum(const std::string& command);

//! Checks whether a character can appear in a thread ID string
bool isTidChar(char c);

//! Checks whether a string is a thread ID string
bool isTidString(const std::string& msg);

//! Parses a thread ID string
void processTidString(const std::string& tidString, std::vector<Thread>& tids);

#endif
