#include "../logger.hpp"
#include "WindowsCommon.hpp"
#include <Windows.h>

namespace windowscommon
{
	NaviError getFileSystems(std::vector<boost::filesystem::path>& roots)
	{
		msglog->log(LOG_ALL, "Entering %s", __FUNCTION__);

		const unsigned int BUFFER_SIZE = 512;

		char buffer[BUFFER_SIZE] = { 0 };

		DWORD written = GetLogicalDriveStrings(sizeof(buffer) - 1, buffer);
		if (!written || written > BUFFER_SIZE)
		{
			return NaviErrors::COULDNT_GET_ROOTS;
		}

		for (unsigned int i = 0; i < written; i += 4)
		{
			roots.push_back(&buffer[i]);
		}

		return 0;
	}

	NaviError getSystemRoot(boost::filesystem::path& root)
	{
		msglog->log(LOG_ALL, "Entering %s", __FUNCTION__);

		char buffer[4] = { 0 };

		if (GetEnvironmentVariable("SystemDrive", buffer, sizeof(buffer)))
		{
			// Bug in boost: buffer needs to be converted to string first, otherwise appending the path separator does not work
			std::string r(buffer);
			root = boost::filesystem::path(r) / "/";
		}
		else
		{
			// This should never actually happen on valid Windows installations because
			// the environment variable SystemDrive should always exist.
			root = "C:/";
		}

		return NaviErrors::SUCCESS;
	}
}