#include <string>

namespace zylib
{
	namespace zycon
	{
		class ByteReader
		{
			private:
				const char* start;
				const char* p;
				unsigned int toRead;
				bool error_;
			
			public:
				ByteReader(const char* start, unsigned int toRead) : start(start), p(start), toRead(toRead), error_(false) { }
				
			bool isDone() const
			{
				return start + toRead == p;
			}
			
			bool isError() const
			{
				return error_;
			}
				
			unsigned int readInt()
			{
				if (p + sizeof(unsigned int) > start + toRead)
				{
					error_ = true;
					
					return 0;
				}
				
				unsigned int value = *(unsigned int*) p;
				
				p += sizeof(unsigned int);
				
				return value;
			}
				
			std::string readString(unsigned int chars)
			{
				if (p + chars > start + toRead)
				{
					error_ = true;
					
					return "";
				}
				
				std::string str(p, chars);
				
				p += chars;
				
				return str;
			}
		};
	}
}
