#include <string>
#include <vector>
#include <utility>
#include <algorithm>
#include <iostream>

namespace zylib
{
	namespace zyline
	{
		/**
		* \brief Parses commandline parameters into a list of string-pairs.
		*
		* Parses commandline parameters into a list of string-pairs. The parser recognizes three types of
		* parameters.
		*
		* -# Normal arguments which can be any kind of strings (list x86 for a cpu name).
		* -# Arguments starting with a '-' character (like -v for verbose mode).
		* -# Arguments starting with a '-' character and followed by another argument without a '-' (like -p 80 to specify port 80).
		*
		* After parsing, arguments of the first two argument types are stored in pairs of the form ("arg", "")
		* while arguments of the third type are stored in pairs of the form ("arg", "value").
		*
		* @param argc Number of arguments.
		* @param argv Argument array.
		*
		* @return The commandline arguments sorted into a list of pairs.
		**/
		std::vector<std::pair<std::string, std::string> > parseCommandLine(unsigned int argc, const char* argv[])
		{
			std::vector<std::pair<std::string, std::string> > retval;
			
			for (unsigned int i=0;i<argc;i++)
			{
				if (argv[i][0] == '-')
				{
					if (i < argc - 1 && argv[i+1][0] != '-')
					{
						retval.push_back(std::make_pair(argv[i], argv[i+1]));
						i++;
						continue;
					}
				}
				
				retval.push_back(std::make_pair(argv[i], ""));
			}
			
			return retval;
		}
	}
}
