#ifndef ILOGTARGET_HPP
#define ILOGTARGET_HPP

#include <iostream>

namespace zylib
{
	namespace zylog
	{
		/**
		* Abstract base class of all log targets.
		**/
		class ILogTarget
		{
			public:
				/**
				* Tells the log target to log a message.
				*
				* @param msg The message to log.
				**/
				virtual void log(const char* msg) = 0;
				
				virtual ~ILogTarget() { }
		};
	}
}
	
#endif
