package com.zynamics.binnavi.standardplugins.callresolver;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JMenuItem;

import BinNavi.API.disassembly.AddressSpace;
import BinNavi.API.disassembly.Module;
import BinNavi.API.plugins.IAddressSpaceMenuPlugin;
import BinNavi.API.plugins.IModuleMenuPlugin;
import BinNavi.API.plugins.PluginInterface;

/**
 * This is the plugin class that gets picked up by BinNavi. The plugin
 * extends the context menus of modules and address spaces in the project
 * tree of the main window.
 */
public final class CallResolverPlugin implements IModuleMenuPlugin, IAddressSpaceMenuPlugin
{
	@Override
	public List<JComponent> extendAddressSpaceMenu(final List<AddressSpace> spaces)
	{
		final List<JComponent> menus = new ArrayList<JComponent>();

		if (spaces.size() == 1)
		{
			menus.add(new JMenuItem(new ResolveCallsAction(PluginInterface.instance().getMainWindow().getFrame(), new AddressSpaceCallResolverTarget(spaces.get(0)))));
		}

		return menus;
	}

	@Override
	public List<JComponent> extendModuleMenu(final List<Module> modules)
	{
		final List<JComponent> menus = new ArrayList<JComponent>();

		if (modules.size() == 1)
		{
			menus.add(new JMenuItem(new ResolveCallsAction(PluginInterface.instance().getMainWindow().getFrame(), new ModuleCallResolverTarget(modules.get(0)))));
		}

		return menus;
	}

	@Override
	public String getDescription()
	{
		return "This plugin can be used to resolve indirect function calls that depend on one more or variable values that are not known to the disassembly.";
	}

	@Override
	public long getGuid()
	{
		return 423547690534790L;
	}

	@Override
	public String getName()
	{
		return "Call Resolver";
	}

	@Override
	public void init(final PluginInterface pluginInterface)
	{
	}

	@Override
	public void unload()
	{
	}
}
