package com.zynamics.binnavi.standardplugins.callresolver;

import java.awt.Font;
import java.awt.GraphicsEnvironment;

/**
 * Contains a helper function for finding the monospace font of the system.
 */
public final class FontHelper
{
	/**
	 * Determines the name of the monospace font of the system.
	 *
	 * @return The name of the system monospace font.
	 */
	public static String getMonospaceFont()
	{
		final GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
		final Font[] allfonts = env.getAllFonts();

		for (final Font font : allfonts)
		{
			if (font.getName().equals("Courier New"))
			{
				return "Courier New";
			}
		}

		return Font.MONOSPACED;
	}

}
