package com.zynamics.binnavi.standardplugins.callresolver;

import BinNavi.API.debug.Debugger;

/**
 * Interface to be implemented by objects that want to be notified about
 * changes in call resolver target objects.
 */
public interface ICallResolverTargetListener
{
	/**
	 * Invoked after the debugger of call resolver target changed.
	 *
	 * @param target The target whose debugger changed.
	 * @param debugger The new debugger of the call resolver target.
	 */
	void changedDebugger(ICallResolverTarget target, Debugger debugger);
}
