package com.zynamics.binnavi.standardplugins.callresolver;

import java.math.BigInteger;
import java.util.List;

import BinNavi.API.debug.Debugger;
import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.Module;

/**
 * Contains a helper function that helps resolve functions.
 */
public final class IndirectCallResolver
{
	/**
	 * Searches for an indirect call given the relocated call address.
	 *
	 * @param debugger The debugger that provides the relocation information.
	 * @param indirectCallAddresses The list of indirect call addresses to search through.
	 * @param callAddress The relocated call address to find.
	 *
	 * @return The found indirect call object.
	 */
	public static IndirectCall findIndirectCall(final Debugger debugger, final List<IndirectCall> indirectCallAddresses, final BigInteger callAddress)
	{
		for (final IndirectCall indirectCall : indirectCallAddresses)
		{
			final Module module = indirectCall.getModule();
			final Address address = indirectCall.getAddress();

			final Address rebasedAddress = debugger.toImagebase(module, address);

			if (rebasedAddress.equals(new Address(callAddress)))
			{
				return indirectCall;
			}
		}

		return null;
	}

}
