package com.zynamics.binnavi.standardplugins.callresolver;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JFrame;

/**
 * This class handles clicks on the menu item that was added
 * to the context menu of modules in the project tree of the
 * main window.
 */
public final class ResolveCallsAction extends AbstractAction
{
	private static final long serialVersionUID = -8259190953437429845L;

	/**
	 * Parent window of the resolver dialog.
	 */
	private final JFrame parent;

	/**
	 * The module whose calls should be resolved.
	 */
	private final ICallResolverTarget module;

	/**
	 * Creates a new action object.
	 *
	 * @param parent Parent window of the resolver dialog.
	 * @param module The module whose calls should be resolved.
	 */
	public ResolveCallsAction(final JFrame parent, final ICallResolverTarget module)
	{
		super("Resolve Calls");

		this.parent = parent;
		this.module = module;
	}

	@Override
	public void actionPerformed(final ActionEvent e)
	{
		CallResolverDialog.show(parent, module);
	}
}
