package com.zynamics.binnavi.standardplugins.coverage;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JFrame;

import BinNavi.API.debug.Debugger;
import BinNavi.API.gui.GraphFrame;
import BinNavi.API.helpers.MessageBox;

/**
 * Menu handler of the Visual Coverage menu of the Plugins menu.
 */
public final class VisualCoverageAction extends AbstractAction
{
	private static final long serialVersionUID = 1511963098319768357L;

	/**
	 * The graph frame whose menu is extended.
	 */
	private GraphFrame graphFrame;

	/**
	 * The active Visual Coverage process. This can be null if no coverage
	 * process is active.
	 */
	private VisualCoverage coverage = null;

	/**
	 * Keeps track of relevant changes in the visual coverage object.
	 */
	private final IVisualCoverageListener traceListener = new InternalTraceListener();

	/**
	 * Creates a new visual coverage action object.
	 *
	 * @param graphFrame The graph frame whose menu is extended.
	 */
	public VisualCoverageAction(final GraphFrame graphFrame)
	{
		super("Visual Coverage");

		this.graphFrame = graphFrame;
	}

	@Override
	public void actionPerformed(final ActionEvent e)
	{
		// TODO: Get a proper parent argument (will be fixed in BinNavi 2.2)
		final JFrame parent = null;

		if (coverage != null)
		{
			MessageBox.showInformation(parent, "Visual Coverage trace is already active");
			return;
		}

		final List<Debugger> debuggers = graphFrame.getDebuggers();

		if (debuggers.size() == 0)
		{
			MessageBox.showInformation(parent, "Visual Coverage trace can not be started because no debugger is configured for this graph.");
			return;
		}
		else if (debuggers.size() == 1)
		{
			final Debugger debugger = debuggers.get(0);

			coverage = new VisualCoverage(parent, debugger, graphFrame.getView2D());

			// Add a listener to recognize when the trace is done.
			coverage.addListener(traceListener);
		}
		else
		{
			MessageBox.showInformation(parent, "Visual Coverage trace can not be started because more than one debugger is configured for this graph.");
			return;
		}
	}

	/**
	 * Frees allocated resources.
	 */
	public void dispose()
	{
		if (coverage != null)
		{
			coverage.removeListener(traceListener);

			coverage.dispose();

			coverage = null;
			graphFrame = null;
		}
	}

	public GraphFrame getFrame()
	{
		return graphFrame;
	}

	/**
	 * Keeps track of relevant changes in the visual trace object.
	 */
	private class InternalTraceListener implements IVisualCoverageListener
	{
		@Override
		public void finishedCoverage()
		{
			// Do not dispose the coverage object here; it cleans itself up
			// when finishing.

			coverage.removeListener(traceListener);

			coverage = null;
		}
	}
}
