package com.zynamics.binnavi.standardplugins.coverage;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JMenuItem;

import BinNavi.API.gui.GraphFrame;
import BinNavi.API.plugins.IGraphMenuPlugin;
import BinNavi.API.plugins.PluginInterface;

/**
 * This plugin demonstrates how to use the BinNavi Plugin API to write a plugin
 * that counts how often the blocks of a graph are hit during a debugging
 * session and paints the blocks in different colors that reflect that
 * hit count.
 */
public final class VisualCoveragePlugin implements IGraphMenuPlugin
{
	/**
	 * Keeps track of all created actions so that they can be cleaned up later.
	 */
	private final List<VisualCoverageAction> createdActions = new ArrayList<VisualCoverageAction>();

	@Override
	public void closed(final GraphFrame graphFrame)
	{
		for (final VisualCoverageAction action : createdActions)
		{
			if (action.getFrame() == graphFrame)
			{
				action.dispose();
				createdActions.remove(action);
				return;
			}
		}
	}

	@Override
	public List<JComponent> extendPluginMenu(final GraphFrame graphFrame)
	{
		// Add a single additional menu to the Plugins menu of the graph window

		final List<JComponent> additionalMenus = new ArrayList<JComponent>();

		final VisualCoverageAction action = new VisualCoverageAction(graphFrame);

		createdActions.add(action);
		additionalMenus.add(new JMenuItem(action));

		return additionalMenus;
	}

	@Override
	public String getDescription()
	{
		return "This plugin can be used to create simple code coverage traces.";
	}

	@Override
	public long getGuid()
	{
		return 54235790543L;
	}

	@Override
	public String getName()
	{
		return "Visual Coverage";
	}

	@Override
	public void init(final PluginInterface pluginInterface)
	{
	}

	@Override
	public void unload()
	{
		// Free all allocated resources if the plugin is unloaded

		for (final VisualCoverageAction action : createdActions)
		{
			action.dispose();
		}

		createdActions.clear();
	}
}
