package com.zynamics.binnavi.standardplugins.pathfinder;

import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

import BinNavi.API.disassembly.Module;

/**
 * Class to implement a tree model which can be filtered by supplying a filter object
 */
public class FilteredTreeModel extends DefaultTreeModel
{
	private static final long serialVersionUID = -404373897710563001L;

	public FilteredTreeModel(final JDialog parent, final Module module)
	{
		super(new FunctionTreeRootNode(parent, module));
	}

	/**
	 * Apply given filter to root node in the tree
	 * The filter is then recursively propagated to all children
	 * @param filter
	 */
	public void setFilter(final TextPatternFilter filter)
	{
		((FunctionTreeRootNode)getRoot()).setFilter(filter);
		nodeStructureChanged((TreeNode)getRoot());
	}
}
