package com.zynamics.binnavi.standardplugins.pathfinder;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.swing.JDialog;

import BinNavi.API.disassembly.Function;
import BinNavi.API.disassembly.Module;

/**
 * The invisible root node of the function tree.
 */
public final class FunctionTreeRootNode extends FunctionTreeNode implements IFunctionTreeNode
{
	private static final long serialVersionUID = 5405216628138805988L;

	/**
	 * Creates a root node object.
	 *
	 * @param parent Parent of the tree the node belongs to.
	 * @param module The module that provides the functions and basic blocks to display.
	 */
	public FunctionTreeRootNode(final JDialog parent, final Module module)
	{
		// Create tree nodes for each function of the module.

		final List<Function> functions = module.getFunctions();

		Collections.sort(functions, new Comparator<Function>()
				{
			@Override
			public int compare(final Function o1, final Function o2)
			{
				return o1.getName().compareToIgnoreCase(o2.getName());
			}
				});

		for (final Function function : functions)
		{
			add(new FunctionTreeFunctionNode(parent, function));
		}
	}

	public void dispose()
	{
		for (int i=0;i<getChildCount();i++)
		{
			final FunctionTreeFunctionNode node = (FunctionTreeFunctionNode)getChildAt(i);

			node.dispose();
		}
	}

	@Override
	public void doubleClicked()
	{
		// The root node is invisible, it can not be double-clicked.
	}

	@Override
	public boolean isVisible()
	{
		return false;
	}
}
