package com.zynamics.binnavi.standardplugins.pathfinder;

/**
 * A filter class which allows to filter strings according to a specified pattern
 */
public class TextPatternFilter
{
	/**
	 * The pattern to be searched for
	 */
	private final String m_pattern;

	public TextPatternFilter(final String pattern)
	{
		if(pattern == null)
		{
			throw new IllegalArgumentException("Error: pattern in function tree filter can not be null");
		}
		m_pattern = pattern.toLowerCase();
	}

	/**
	 * 
	 * @param text Text to check for a pattern
	 * @return True if text matches the pattern and thus should be included in the list of tree nodes
	 */
	public boolean matchesFilter(final String text)
	{
		final String lowText = text.toLowerCase();

		return m_pattern.length() == 0 || lowText.contains(m_pattern);
	}
}
