package com.zynamics.binnavi.standardplugins.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public final class CDialogEscaper
{
	private final JDialog m_dialog;

	public CDialogEscaper(final JDialog dialog)
	{
		m_dialog = dialog;

		// Allow the user to close the dialog with the ESC key.
		final KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
		((JComponent) dialog.getRootPane()).registerKeyboardAction(new InternalListener(), "doEscape", escapeKeyStroke, JComponent.WHEN_IN_FOCUSED_WINDOW); 
	}

	private class InternalListener implements ActionListener
	{
		@Override
		public void actionPerformed(final ActionEvent arg0)
		{
			m_dialog.setVisible(false);

			m_dialog.dispose();
		}
	}
}
