package com.zynamics.binnavi.standardplugins.utils;


import java.awt.Component;
import java.util.Hashtable;

import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * Taken from http://www.crionics.com/products/opensource/faq/swing_ex/JTreeExamples4.html
 *
 * @version 1.0 01/12/99
 */
public final class IconNodeRenderer extends DefaultTreeCellRenderer
{
	private static final long serialVersionUID = 2629851490064875893L;

	@SuppressWarnings("unchecked")
	@Override
	public Component getTreeCellRendererComponent(final JTree tree, final Object value, final boolean sel, final boolean expanded, final boolean leaf, final int row, final boolean hasFocus)
	{
		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

		Icon icon = ((IconNode) value).getIcon();

		if (icon == null)
		{
			final Hashtable<String, Icon> icons = (Hashtable<String, Icon>) tree.getClientProperty("JTree.icons"); 
			final String name = ((IconNode) value).getIconName();
			if (icons != null && name != null)
			{
				icon = icons.get(name);
				if (icon != null)
				{
					setIcon(icon);
				}
			}
		}
		else
		{
			setIcon(icon);
		}

		return this;
	}
}
