package com.zynamics.binnavi.standardplugins.utils;

/**
 * Simple pair class.
 *
 * @param <S> The type of the first element.
 * @param <T> The type of the second element.
 */
public final class Pair<S, T>
{
	/**
	 * The first element of the pair.
	 */
	private final S first;

	/**
	 * The second element of the pair.
	 */
	private final T second;

	/**
	 * Creates a new pair.
	 *
	 * @param first The first element of the pair.
	 * @param second The second element of the pair.
	 */
	public Pair(final S first, final T second)
	{
		this.first = first;
		this.second = second;
	}

	@Override
	public boolean equals(final Object obj)
	{
		if (!(obj instanceof Pair))
		{
			return false;
		}

		final Pair<?, ?> p = (Pair<?, ?>) obj;

		return p.first.equals(first) && p.second.equals(second);
	}

	/**
	 * Returns the first element of the pair.
	 *
	 * @return The first element of the pair.
	 */
	public S first()
	{
		return first;
	}

	@Override
	public int hashCode()
	{
		return first.hashCode() * second.hashCode();
	}

	/**
	 * The second element of the pair.
	 *
	 * @return The second element of the pair.
	 */
	public T second()
	{
		return second;
	}

	@Override
	public String toString()
	{
		return "< " + first + ", " + second + ">";
	}
}
