create table bn_projects (
	id int unsigned not null auto_increment,
	name text not null,
	description text not null,
	creation_date timestamp not null default CURRENT_TIMESTAMP,
	modification_date timestamp not null default 0,
	stared boolean not null default false,
	primary key(id)
) ENGINE=InnoDB;

create table bn_debuggers (
	id int unsigned not null auto_increment,
	name text not null,
	host text not null,
	port int unsigned not null,
	primary key (id)
) ENGINE=InnoDB;

create table bn_tags (
	id smallint unsigned not null auto_increment,
	parent_id smallint unsigned,
	name text not null,
	description text not null ,
	type enum ('view_tag', 'node_tag') not null,
	primary key(id),
	foreign key(parent_id) references bn_tags(id) on delete cascade
) ENGINE=InnoDB;

create table bn_modules (
	id int unsigned not null auto_increment,
	raw_module_id int unsigned,
	name text not null,
	description text not null,
	md5 char(32) not null,
	sha1 char(40) not null,
	debugger_id int unsigned null,
	image_base bigint unsigned not null default 0,
	file_base bigint unsigned not null default 0,
	import_time timestamp not null default CURRENT_TIMESTAMP,
	modification_date timestamp not null default 0,
	data longblob,
	stared boolean not null default false,
	initialization_state int unsigned not null default 0,
	primary key (id),
	foreign key(debugger_id) references bn_debuggers(id) on delete set null,
	foreign key(raw_module_id) references modules(id)
) ENGINE=InnoDB;

create table bn_data_parts (
	module_id int unsigned not null,
	part_id int unsigned not null,
	data mediumblob,
	primary key(module_id, part_id),
	foreign key(module_id) references bn_modules(id) ON DELETE cascade
) ENGINE=InnoDB;

create table bn_project_debuggers (
	project_id int unsigned not null,
	debugger_id int unsigned not null,
	foreign key(project_id) references bn_projects(id) on delete cascade,
	foreign key(debugger_id) references bn_debuggers(id) on delete cascade
) ENGINE=InnoDB;

create table bn_address_spaces (
	id int unsigned not null auto_increment,
	project_id int unsigned not null,
	debugger_id int unsigned,
	name text not null,
	description text not null,
	creation_date timestamp not null default CURRENT_TIMESTAMP,
	modification_date timestamp not null default 0,
	primary key(id),
	foreign key(project_id) references bn_projects(id) on delete cascade,
	foreign key(debugger_id) references bn_debuggers(id) on delete set null
) ENGINE=InnoDB;

create table bn_space_modules (
	module_id int unsigned not null,
	address_space_id int unsigned not null,
	image_base bigint unsigned not null,
	primary key(address_space_id, module_id),
	foreign key(address_space_id) references bn_address_spaces(id) on delete cascade,
	foreign key(module_id) references bn_modules(id) 
) ENGINE=InnoDB;

create table bn_functions (
	module_id int unsigned not null,
	address bigint unsigned not null,
	name text not null,
	original_name text not null,
	type enum('normal', 'library', 'import', 'thunk', 'adjustor_thunk') not null,
	description text not null,
	comment text null,
	parent_module_name text,
	parent_module_id int unsigned,
	parent_module_function bigint unsigned,	
	primary key (module_id, address),
	foreign key (module_id) references bn_modules(id) on delete cascade,
	foreign key (parent_module_id, parent_module_function) references bn_functions(module_id, address) on delete set null
) ENGINE=InnoDB;

create table bn_instructions (
	module_id int unsigned not null,
	address bigint unsigned not null,
	mnemonic varchar(32) not null,
	comment text null,
	data blob(32) not null,
	native boolean not null,
	architecture enum ('x86-32', 'x86-64', 'ARM-32', 'PowerPC-32', 'PowerPC-64', 'MIPS-32', 'MIPS-64', 'GENERIC-32', 'GENERIC-64', 'REIL', 'RREIL' ) not null,
	foreign key(module_id) references bn_modules(id) ON DELETE cascade,
	primary key(module_id, address)
) ENGINE=InnoDB;

create table bn_expression_tree_ids (
	module_id int unsigned not null,
	id int unsigned not null,
	primary key(module_id, id)
) ENGINE=InnoDB;

create table bn_operands (
	module_id int unsigned not null,
	address bigint unsigned not null,
	expression_tree_id int unsigned not null,
	position int unsigned not null,
	primary key(module_id, address, position),
	foreign key(module_id, address) references bn_instructions(module_id, address) ON DELETE cascade,
	foreign key(module_id, expression_tree_id) references bn_expression_tree_ids(module_id, id) on delete cascade
) ENGINE=InnoDB;

create table bn_expression_tree (
	module_id int unsigned not null,
	id int unsigned not null,
	type enum('symbol', 'integer_literal', 'float_literal', 'operator', 'register', 'size_prefix', 'dereference') not null,
	symbol varchar(256),
	immediate bigint,
	position int unsigned not null,
	parent_id int unsigned null,
	primary key(module_id, id),
	foreign key(module_id) references bn_modules(id),
	index(module_id, id, parent_id)
) ENGINE=InnoDB;

create table bn_expression_tree_mapping (
	module_id int unsigned not null,
	tree_id int unsigned not null,
	tree_node_id int unsigned not null,
	primary key(module_id, tree_id, tree_node_id),
	foreign key(module_id, tree_id) references bn_expression_tree_ids(module_id, id),
	foreign key(module_id, tree_node_id) references bn_expression_tree(module_id, id) ON DELETE cascade
) ENGINE=InnoDB;

create table bn_expression_substitutions (
	module_id int unsigned not null,
	address bigint unsigned not null,
	position int unsigned not null,
	expression_id int unsigned not null,
	replacement text not null,
	primary key(module_id, address, position, expression_id),
	foreign key(module_id, address, position) references bn_operands(module_id, address, position) ON DELETE cascade,
	foreign key(module_id, expression_id) references bn_expression_tree(module_id, id)
) ENGINE=InnoDB;

create table bn_address_references (
	module_id int unsigned not null,
	address bigint unsigned not null,
	position int unsigned not null,
	expression_id int unsigned not null,
	type enum('conditional_true', 'conditional_false', 'unconditional', 'switch', 'call_direct', 'call_indirect', 'call_virtual', 'data', 'data_string') not null,
	target bigint unsigned not null,
	primary key(module_id, address, position, expression_id, type, target),
	foreign key(module_id, address, position) references bn_operands(module_id, address, position) ON DELETE cascade,
	index (target),
	index (type)
) ENGINE=InnoDB;

create table bn_views (
	id int unsigned not null auto_increment,
	type enum('native', 'non-native') not null,
	name text not null,
	description text not null,
	creation_date timestamp not null default CURRENT_TIMESTAMP,
	modification_date timestamp not null default 0,
	stared boolean not null default false,
	primary key (id),
	index (type)
) ENGINE=InnoDB;

create table bn_tagged_views (
	view_id int unsigned not null,
	tag_id smallint unsigned not null,
	primary key(view_id, tag_id),
	foreign key(view_id) references bn_views(id) on delete cascade,
	foreign key(tag_id) references bn_tags(id) on delete cascade
) ENGINE=InnoDB;

create table bn_project_views (
	project_id int unsigned not null,
	view_id int unsigned not null,	
	primary key (view_id),
	foreign key (view_id) references bn_views(id) on delete cascade,
	foreign key (project_id) references bn_projects(id) on delete cascade
) ENGINE=InnoDB;
	
create table bn_module_views (
	module_id int unsigned not null,
	view_id int unsigned not null,
	primary key (view_id),
	foreign key (view_id) references bn_views(id) on delete cascade,
	foreign key (module_id) references bn_modules(id) ON DELETE cascade
) ENGINE=InnoDB;
	
create table bn_view_settings (
	view_id int unsigned not null,
	name varchar(255) not null,
	value text not null,
	primary key (view_id, name),
	foreign key (view_id) references bn_views(id) on delete cascade 
) ENGINE=InnoDB;

create table bn_function_views (
	module_id int unsigned not null,
	view_id int unsigned not null,
	function bigint unsigned not null,
	primary key (view_id),
	foreign key (view_id) references bn_views(id) on delete cascade,
	foreign key (module_id, function) references bn_functions(module_id, address) on delete cascade
) ENGINE=InnoDB;

create table bn_nodes (
	id int unsigned not null auto_increment,
	view_id int unsigned not null,
	parent_id int unsigned,
	type enum('code', 'function', 'group', 'text') not null,
	x double not null,
	y double not null,
	width double not null,
	height double not null,
	color int not null,
	bordercolor int not null default 0,
	selected boolean not null,
	visible boolean not null,
	primary key (id),
	index(view_id)
) ENGINE=InnoDB;

create table bn_nodes_spacemodules (
	module_id int unsigned not null,
	node int unsigned not null,
	address_space int unsigned,
	primary key (node),
	foreign key (node) references bn_nodes(id) on delete cascade,
	foreign key (address_space) references bn_address_spaces(id) on delete cascade,
	foreign key (module_id) references bn_modules(id)
) ENGINE=InnoDB;

create table bn_function_nodes (
	module_id int unsigned not null,
	node_id int unsigned not null,
	function bigint unsigned not null,
	comment text null,
	primary key (node_id),
	foreign key (node_id) references bn_nodes(id) on delete cascade,
	foreign key (module_id, function) references bn_functions(module_id, address) on delete cascade
) ENGINE=InnoDB;

create table bn_group_nodes (
	node_id int unsigned not null,
	comment text null,
	collapsed boolean not null,
	primary key (node_id),
	foreign key (node_id) references bn_nodes(id) on delete cascade
) ENGINE=InnoDB;

alter table bn_nodes add foreign key (parent_id) references bn_group_nodes(node_id) on delete set null;

create table bn_text_nodes (
	node_id int unsigned not null,
	text text null,
	primary key (node_id),
	foreign key (node_id) references bn_nodes(id) on delete cascade
) ENGINE=InnoDB;

create table bn_code_nodes (
	module_id int unsigned not null,
	node_id int unsigned not null,
	parent_function bigint unsigned,
	comment text null,
	primary key (node_id),
	foreign key (node_id) references bn_nodes(id) on delete cascade,
	foreign key (module_id, parent_function) references bn_functions(module_id, address) on delete cascade
) ENGINE=InnoDB;

create table bn_codenode_instructions (
	module_id int unsigned not null,
	node_id int unsigned not null,
	position int unsigned not null,
	address bigint unsigned not null,
	comment text null,
	primary key(node_id, position),
	foreign key(node_id) references bn_nodes(id) on delete cascade,
	foreign key(module_id, address) references bn_instructions(module_id, address) on delete cascade
) ENGINE=InnoDB;

create table bn_edges (
	id int unsigned not null auto_increment,
	source_node_id int unsigned not null,
	target_node_id int unsigned not null,
	comment text null,
	x1 double not null,
	y1 double not null,
	x2 double not null,
	y2 double not null,
	type enum('conditional_true', 'conditional_false', 'unconditional', 'switch', 'conditional_true_loop', 'conditional_false_loop', 'unconditional_loop', 'enter_inlined', 'leave_inlined', 'cross_module', 'cross_address_space', 'text_edge') not null,
	color int not null,
	visible boolean not null,
	selected boolean not null,
	primary key (id),
	foreign key (source_node_id) references bn_nodes(id) on delete cascade,
	foreign key (target_node_id) references bn_nodes(id) on delete cascade
) ENGINE=InnoDB;

create table bn_edge_paths (
	edge_id int unsigned not null,
	position int unsigned not null,
	x double not null,
	y double not null,
	primary key (edge_id, position),
	foreign key (edge_id) references bn_edges(id) on delete cascade
) ENGINE=InnoDB;

create table bn_tagged_nodes(
	node_id int unsigned not null,
	tag_id smallint unsigned not null,
	primary key(node_id, tag_id),
	foreign key(node_id) references bn_nodes(id) on delete cascade,
	foreign key(tag_id) references bn_tags(id) on delete cascade
) ENGINE=InnoDB;

create table bn_global_edge_comments (
	src_module_id int unsigned not null,
	dst_module_id int unsigned not null,
	src_address bigint unsigned not null,
	dst_address bigint unsigned not null,
	comment text not null,
	primary key (src_module_id, dst_module_id, src_address, dst_address)
) ENGINE=InnoDB;

create table bn_global_node_comments (	
	module_id int unsigned not null,
	address bigint unsigned not null,
	comment text not null,
	primary key(module_id, address),
	foreign key (module_id) references bn_modules(id) ON DELETE cascade
) ENGINE=InnoDB;

create table bn_module_settings (
	module_id int unsigned not null,
	name varchar(255) not null,
	value text not null,
	primary key(module_id, name),
	foreign key(module_id) references bn_modules(id) ON DELETE cascade
) ENGINE=InnoDB;

create table bn_project_settings (
	project_id int unsigned not null,
	name varchar(255) not null,
	value text not null,
	primary key(project_id, name),
	foreign key(project_id) references bn_projects(id) on delete cascade
) ENGINE=InnoDB;

create table bn_traces (
	id int unsigned not null auto_increment,
	view_id int unsigned not null,
	name text not null,
	description text not null,
	primary key(id),
	index(view_id)
) ENGINE=InnoDB;

create table bn_module_traces (
	module_id int unsigned not null,
	trace_id int unsigned not null,
	primary key(module_id, trace_id),
	foreign key(module_id) references bn_modules(id) ON DELETE cascade,
	foreign key(trace_id) references bn_traces(id) on delete cascade
) ENGINE=InnoDB;

create table bn_project_traces (
	project_id int unsigned not null,
	trace_id int unsigned not null,
	primary key(project_id, trace_id),
	foreign key(project_id) references bn_projects(id) on delete cascade,
	foreign key(trace_id) references bn_traces(id) on delete cascade
) ENGINE=InnoDB;

create table bn_trace_events (
	module_id int unsigned,
	trace_id int unsigned not null,
	position int unsigned not null,
	tid bigint unsigned not null,
	address bigint unsigned not null,
	type enum('echo breakpoint', 'regular breakpoint'),
	primary key(trace_id, position),
	foreign key(trace_id) references bn_traces(id) on delete cascade,
	foreign key(module_id) references bn_modules(id) ON DELETE cascade
) ENGINE=InnoDB;

create table bn_trace_event_values (
	trace_id int unsigned not null,
	position int unsigned not null,
	register_name varchar(50) not null,
	register_value bigint not null,
	memory_value blob not null,
	primary key(trace_id, position, register_name),
	foreign key(trace_id, position) references bn_trace_events(trace_id, position) on delete cascade
) ENGINE=InnoDB;

