/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-97 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su
 *                              FIDO:   2:5020/209
 *
 */

#ifndef __FPRO_H
#define __FPRO_H
#pragma pack(push, 1)

//
//      This file contains q.. counterparts of FILE* functions from Clib.
//      The only difference is that they set 'qerrno' variable too.
//      You should not use C standard I/O functions in your modules.
//      The reason: Borland keep FILE * information local to a DLL
//      so if you open a file in the plugin and pass the handle to the
//      kernel, the kernel will not be able to use it.
//


#include <stdio.h>

idaman FILE *ida_export qfopen(const char *file, const char *mode);
idaman int   ida_export qfread(FILE *fp, void *buf, size_t n);
idaman int   ida_export qfwrite(FILE *fp, const void *buf, size_t n);
idaman long  ida_export qftell(FILE *fp);
idaman int   ida_export qfseek(FILE *fp, long offset, int whence);                  /* 0-Ok */
idaman int   ida_export qfclose(FILE *fp);
idaman int   ida_export qflush(FILE *fp);         // flush stream and call dup/close(). 0 - ok
idaman FILE *ida_export qtmpfile(void);
idaman char *ida_export qtmpnam(char *buf);       // returns temporary file name
                                           // (abs path, includes directory, uses TEMP/TMP vars)

idaman int ida_export qfputc(int chr,FILE *fp);
idaman int ida_export qfgetc(FILE *fp);
idaman char *ida_export qfgets(char *s,int len,FILE *fp);
idaman int ida_export qfputs(const char *s,FILE *fp);
idaman int ida_export qvfprintf(FILE *fp,const char *fmt,va_list va);
inline int qfprintf(FILE *fp,const char *fmt,...)
{
  va_list va;
  va_start(va, fmt);
  int code = qvfprintf(fp, fmt, va);
  va_end(va);
  return code;
}

#if !defined(feof) || !defined(ferror)
#error  feof or ferror are not macros!
#endif

#ifdef __ONLY_PRO_FUNCS__
#undef fileno
#undef setmode
#define fopen           dont_use_this_function
#define fread           dont_use_this_function
#define fwrite          dont_use_this_function
#define ftell           dont_use_this_function
#define fseek           dont_use_this_function
#define fclose          dont_use_this_function
#define fflush          dont_use_this_function
#define tmpfile         dont_use_this_function
#define tmpnam          dont_use_this_function
#define fputc           dont_use_this_function
#define fgetc           dont_use_this_function
#define fgets           dont_use_this_function
#define fputs           dont_use_this_function
#define fprintf         dont_use_this_function
#define vfprintf        dont_use_this_function
#define fileno          dont_use_this_function
#define setmode         dont_use_this_function
#ifdef putchar
#undef putchar
#define putchar(c)      qfputc(c, stdout)
#endif
#ifdef getchar
#undef getchar
#define getchar()       qfgetc(stdin)
#endif
#endif

/*==================================================*/
/* Add-ins for 2..32 byte read/writes.
        fp   - pointer to file
        res  - value read from file
        size - size of value in bytes (1..32)
        mostfirst - is MSB first? (0/1)
   All these functions return 0 - Ok */

idaman int ida_export freadbytes(FILE *fp,void *res,int size,int mostfirst);
idaman int ida_export fwritebytes(FILE *fp,const void *l,int size,int mostfirst);

#define DEF_FREADBYTES(read, write, type, size)                         \
        inline int read(FILE *fp, type *res, bool mostfirst)            \
                { return freadbytes(fp, res, size, mostfirst); }        \
        inline int write(FILE *fp, const type *res, bool mostfirst)     \
                { return fwritebytes(fp, res, size, mostfirst); }
                
DEF_FREADBYTES(fread2bytes, fwrite2bytes, short, 2)                
DEF_FREADBYTES(fread2bytes, fwrite2bytes, ushort, 2)                
DEF_FREADBYTES(fread4bytes, fwrite4bytes, long, 4)                
DEF_FREADBYTES(fread4bytes, fwrite4bytes, ulong, 4)                
DEF_FREADBYTES(fread8bytes, fwrite8bytes, longlong, 8)                
DEF_FREADBYTES(fread8bytes, fwrite8bytes, ulonglong, 8)                

#pragma pack(pop)
#endif
