
# Create configuration files

!include "allmake.mak"

all:    w32vs.cfg$(CFGSUF) w64vs.cfg$(CFGSUF) cearm.cfg$(CFGSUF)

!ifndef VC32_USE_VC8
w32vs.cfg$(CFGSUF): makeenv_vc.mak allmake.mak __vs.cfg
        $(CP) __vs.cfg $@
        @echo /I$(MSVC6DIR)Include              >>$@
#       All warnings on
        @echo /W2       >>$@
!else
w32vs.cfg$(CFGSUF):     __vs.cfg __vc8.cfg
        $(CP) __vs.cfg + __vc8.cfg $@
!endif

w64vs.cfg$(CFGSUF):     __vs.cfg __vc8.cfg
        $(CP) /b __vs.cfg + __vc8.cfg $@
        @echo /D__AMD64__ >>$@


__vc8.cfg: makeenv_vc.mak defaults.mk allmake.mak
        @echo /I$(MSVC8DIR)Include              >$@
!ifndef VC8_WITHOUT_PSDK
        @echo /I$(MSVC8DIR)PlatformSDK\Include  >>$@
!endif
!ifdef  VC8INCLUDE1
        @echo /I$(VC8INCLUDE1) >>$@
!endif
!ifdef  VC8INCLUDE2
        @echo /I$(VC8INCLUDE2) >>$@
!endif
!ifdef  VC8INCLUDE3
        @echo /I$(VC8INCLUDE3) >>$@
!endif
#       All warnings on
        @echo /Wall     >>$@
#       warning C4018: '>=' : signed/unsigned mismatch
        @echo /wd4018   >>$@
#       warning C4061: enumerator 'xxx' in switch of enum 'yyy' is not explicitly handled by a case label
        @echo /wd4061   >>$@
#       warning C4121: 'xxx': alignment of a member was sensitive to packing
        @echo /wd4121   >>$@
#       warning C4127: conditional expression is constant
        @echo /wd4127   >>$@
#       warning C4146: unary minus operator applied to unsigned type, result still unsigned
        @echo /wd4146   >>$@
#       warning C4200: nonstandard extension used: zero-sized array in struct/union
        @echo /wd4200   >>$@
#       warning C4201: nonstandard extension used : nameless struct/union
        @echo /wd4201   >>$@
#       warning C4245: 'xxx' : conversion from 'a' to 'b', signed/unsigned mismatch
        @echo /wd4245   >>$@
#       warning C4310: cast truncates constant value
        @echo /wd4310   >>$@
#       warning C4324: 'xxx' : structure was padded due to __declspec(align())
        @echo /wd4324   >>$@
#       warning C4334: 'xx' : result of 32-bit shift implicitly converted to 64 bits (was 64-bit shift intended?)
        @echo /wd4334   >>$@
#       warning C4365: 'xx' : signed/unsigned mismatch (= or return)
        @echo /wd4365   >>$@
#       warning C4371: 'xxx' : layout of class may have changed from a previous version of the compiler due to better packing of member 'xxx'
        @echo /wd4371   >>$@
#       warning C4389: '!=' : signed/unsigned mismatch
        @echo /wd4389   >>$@
#       warning C4480: '!=' :  nonstandard extension used: ....
        @echo /wd4480   >>$@
#       warning C4512: 'xxx' : assignment operator could not be generated
        @echo /wd4512   >>$@
#       warning C4514: 'xxx' : unreferenced inline function has been removed
        @echo /wd4514   >>$@
#       warning C4548: expression before comma has no effect; expected expression with side-effect
        @echo /wd4548   >>$@
#       warning C4611: interaction between '_setjmp' and C++ object destruction is non-portable
        @echo /wd4611   >>$@
#       warning C4619: pragma warning : there is no warning number 'xxx'
        @echo /wd4619   >>$@
#       warning C4625: 'xxx' : copy constructor could not be generated because a base class copy constructor is inaccessible
        @echo /wd4625   >>$@
#       warning C4626: 'xxx' : assignment operator could not be generated because a base class assignment operator is inaccessible
        @echo /wd4626   >>$@
#       warning C4640: 'p' : construction of local static object is not thread-safe
        @echo /wd4640   >>$@
#       warning C4668: 'xxx' is not defined as a preprocessor macro, replacing with '0' for '#if/#elif'
        @echo /wd4668   >>$@
#       warning C4686: 'xxx' : possible change in behavior, change in UDT return calling convention
        @echo /wd4686   >>$@
#       warning C4710: 'xxx' : function not inlined
        @echo /wd4710   >>$@
#       warning C4711: 'xxx' : function select for automatic inline expansion
        @echo /wd4711   >>$@
#       warning C4800: 'BOOL' : forcing value to bool 'true' or 'false' (performance warning)
        @echo /wd4800   >>$@
#       warning C4820: 'xxx' : 'x' bytes padding added after member 'xxx'
        @echo /wd4820   >>$@
#       warning C4917: 'xxx' : a GUID can only be associated with a class, interface or namespace
        @echo /wd4917   >>$@
#       warning C4996: 'xxx' was declared deprecated
        @echo /wd4996   >>$@
#

cearm.cfg$(CFGSUF): makeenv_vc.mak allmake.mak defaults.mk
        $(CP) &&|
#this file is generated by make, don't edit
/I$(IDA)include
/I"$(MSVCARMDIR)Include"
/I"$(ARMSDK)Include$(ARMINCSUF)"
/nologo
#       Merge duplicate strings
/GF
#       Enable RTTI
/GR
#       No standard stack frame
/Oy
#       Maximum optimization
/Ox
#       All warnings on
/W2
#       Exception handling
/EHa
/DMAXSTR=1024
/DNO_TV_STREAMS
/D__NT__
/DARM
/DUNDER_CE
/DUNICODE
/D_WIN32_WCE=0x420
!ifdef ARM_VC8
/DARM_VC8
!endif
| $@

__vs.cfg:     makeenv_vc.mak allmake.mak defaults.mk
        $(CP) &&|
#this file is generated by make, don't edit
/I$(IDA)include
/nologo
#       Optimize code for Windows application
/GA
#       Merge duplicate strings
/GF
#       Exception handling
/EHa
#       Enable RTTI
/GR
#       No standard stack frame
/Oy
/DMAXSTR=1024
/DNO_TV_STREAMS
/D__VC__
/D__NT__
| $@
