.code

; decrypt_mangled_api, decrypt_asciiz_and_firstthunk & fix_orig_thunk routines


;_________________________________________________________________________________________
; everyone can steal code, but only a chosen few can understand
; 008E99D0 demangle_this_thunk, safedisc r4b
; 008E8950 demangle_this_thunk, safedisc r4

decrypt_mangled_api:

    mov     eax, [memory_ptr]
    mov     edi, [import_ptr]
    add     edi, eax

dma_get_next_iid:
    mov     ebx, [edi]     ; edi points to image_import_descriptor
    or      ebx, [edi+0Ch]
    jne     more_to_demangle
    ret

more_to_demangle:
    mov     esi, [edi+0Ch]    ; pointer to library name
    sub     esi, [rdata_va_offset]
    add     esi, eax
    cmp     [esi], 'NREK' ; 'KERN'
    je      demangle_this_thunk
    cmp     [esi], 'RESU' ; 'USER'
    je      demangle_this_thunk
    cmp     [esi], 'nrek' ; 'kern'
    je      demangle_this_thunk
    cmp     [esi], 'resu' ; 'user'
    je      demangle_this_thunk

demangle_next_iid:
    add     edi, 14h
    jmp     dma_get_next_iid


demangle_this_thunk:
    mov ebx, [edi]
    sub ebx, [rdata_va_offset]
    add ebx, eax
    mov [de_thunk_ptr], ebx
    xor edx, edx

dma_count_api_pointers:
    inc edx
    cmp dword ptr [ebx+4*edx], 00000000
    jne dma_count_api_pointers
    mov [api_counter], edx
    call dm_build_and_sort_table
    call dm_use_table_to_sort_thunk
    jmp demangle_next_iid


dm_build_and_sort_table:
    pushad
    xor ebp, ebp
    xor edx, edx
    mov esi, [api_counter]
    mov eax, esi
    
dm_count_bits:
    inc edx
    shr eax, 1
    jne dm_count_bits       ; count BIT's in 'api counter'
    mov [dm_bit_counter], edx
    mov edi, [decrypt_key]
    lea ebx, demanglebuffer1
    xor eax, eax

dm_build_table:             ; build a table of ascending dwords, the size of the amount of pointers
    mov [ebx+4*eax], eax
    inc eax
    cmp eax, esi            ; cmp current_no, max_no
    jb dm_build_table       ; jb carry_on_building_table

dm_pseudo_sort:             ; sort the table into the correct order, using
    imul edi, 35E85A6Dh     ; these two consts, and morphing the decrypt key with them
    add edi, 361962E9h
    mov edx, [dm_bit_counter]
    mov ecx, edx            ; copy bit counter
    mov eax, edi            ; copy result of maths
    shr eax, cl             ; shift result right x bits
    mov ecx, 20h            ; 20h, 32 bits ;)
    sub ecx, edx            ; sub 32 off bit counter
    imul eax, esi           ; imul shifted_result, api_pointer_count
    shr eax, cl             ; haha, shift again
    cmp eax, ebp            ; cmp result_from_maths, current_pointer
    je dm_skip_swap         ; jz dont_sort :p
    push dword ptr [ebx+4*ebp]      ; push current pointer
    mov edx, [ebx+4*eax]            ; edx=pointer that maths gave us
    mov [ebx+4*ebp] , edx           ; and swap them around
    pop dword ptr [ebx+4*eax]       ;)

dm_skip_swap:
    inc ebp
    cmp ebp, esi
    jb dm_pseudo_sort
    popad
    ret


dm_use_table_to_sort_thunk:
    pushad   
    xor eax, eax
    mov esi, [de_thunk_ptr]
    lea edi, demanglebuffer2
    mov ecx, [api_counter]
    repz movsd
    lea esi, demanglebuffer1
    mov edi, [de_thunk_ptr]

demangle_l6:
    xor ebp, ebp

demangle_l7:
    cmp eax, dword ptr [esi+4*ebp]
    je demangle_l8
    inc ebp
    jmp demangle_l7

demangle_l8:
    mov ecx, dword ptr [edi+4*ebp]
    mov [4*eax+offset demanglebuffer2], ecx
    inc eax
    cmp eax, [api_counter]
    jb demangle_l6
    lea esi, demanglebuffer2
    mov ecx, [api_counter]
    repz movsd
    popad
    ret



;_________________________________________________________________________________________ 

decrypt_asciiz_and_firstthunk:
    pushad
    lea     ebp, api_pointers  
    mov     ebx, [memory_ptr]
    mov     edx, [import_ptr]
    add     edx, ebx
    sub     ebx, [rdata_va_offset]

next_iid:
    mov     eax, [edx]              ; yak yak yak, edx -> image_import_descriptors
    or      eax, [edx+0Ch]
    jne     scan4k32_or_u32         ; jne were not on the NULL terminator of the iid's
    popad
    ret


scan4k32_or_u32:
    mov esi, [edx+0Ch]    ; pointer to lib name
    add esi, ebx
    cmp [esi], 'NREK'     ; 'KERN'
    je correct_iid
    cmp [esi], 'RESU'     ; 'USER'
    je correct_iid
    cmp [esi], 'nrek'     ; 'kern'
    je correct_iid
    cmp [esi], 'resu'     ; 'user'
    jne try_next_iid
    
correct_iid:
    mov eax, [ebp]  ; load missing pointer into eax..
    add ebp, 4
    mov esi, [edx]              ; ptr to original_first_thunk
    add esi, ebx                ; add fixed memptr to it
    mov ecx, [esi]              ; ptr to asciiz
    or ecx, ecx                 ; fucked thunk arrays begin NULL terminated :D
    jne try_next_iid
    mov [esi], eax              ; stamp missing key into NULL

next_asciiz_pointer:
    mov edi, [esi]
    or edi, edi
    jne more_asciiz_2_decrypt

try_next_iid:
    add edx, 14h
    jmp next_iid

more_asciiz_2_decrypt:
    xor edi, [decrypt_key]      ; main decrypt key xor asciiz pointer
    mov [esi], edi              ; stamp it back into thunk
    add esi, 4
    add edi, ebx                ; edi -> asciiz now
    mov word ptr [edi], 0       ; NULL the 'hint'
    add edi, 2
    mov cl, [asciiz_key]
decrypt_asciiz_loop:            ; decrypt the asciiz
    mov al, byte ptr [edi]
    mov ch, al
    xor al, cl
    mov byte ptr [edi], al
    je next_asciiz_pointer
    mov cl, ch
    inc edi
    jmp decrypt_asciiz_loop 

;_________________________________________________________________________________________ 

fix_orig_thunk: ; copy fixed first thunk, over original first thunk, thus, fixing it
    pushad
    xor     ebp, ebp
    xor     ecx, ecx
    mov     ebx, [memory_ptr]
    mov     edx, [import_ptr]
    add     edx, ebx
    sub     ebx, [rdata_va_offset]

flt_scan4last_iid:
    mov     eax, [edx]          ; edx points to image_import_descriptor
    or      eax, [edx+0Ch]      ; scan for the NULL terminating image_import_descriptor
    jne     flt_check_for_kORu  ; jump if not equal to fix_last_thunk_check_for_kernel_or_user
    popad
    ret

flt_check_for_kORu:
    mov     esi, [edx+0Ch]      ; pointer to library name
    add     esi, ebx
    cmp     [esi], 'NREK'       ; KERN - EL
    je      flt_kernel_iid
    cmp     [esi], 'nrek'       ; kern - el
    je      flt_kernel_iid
    cmp     [esi], 'RESU'       ; USER
    je      flt_user_iid
    cmp     [esi], 'resu'       ; user
    jne     flt_next_iid

flt_user_iid:
    mov     esi, [edx]                  ; ptr to original first thunk
    add     esi, ebx
    mov     edi, [edx+10h]              ; ptr to 'fixed' first thunk
    mov     [begin_user_thunk+ecx], edi ; data we require for 'fixing' code section
    add     edi, ebx

flt_copy_user_pointers:
    mov     eax, [esi]
    mov     dword ptr [edi], eax        ; copy first thunk pointers into original first thunk
    add     esi, 4
    add     edi, 4
    or      eax, eax
    jne     flt_copy_user_pointers
    sub     edi, ebx
    sub     edi, 4
    mov     [end_user_thunk+ecx], edi   ; data we require for 'fixing' code section
    add     ecx, 04h
    add     edx, 14h
    jmp     flt_scan4last_iid

flt_kernel_iid:
    mov     esi, [edx]                      ; ptr to original first thunk
    add     esi, ebx
    mov     edi, [edx+10h]                  ; ptr to 'fixed' first thunk
    mov     [begin_kernel_thunk+ebp], edi   ; data we require for 'fixing' code section
    add     edi, ebx

flt_copy_kernel_pointers:
    mov     eax, [esi]
    mov     [edi], eax                  ; copy first thunk pointers into original first thunk
    add     esi, 4
    add     edi, 4
    or      eax, eax
    jne     flt_copy_kernel_pointers
    sub     edi, ebx
    sub     edi, 4
    mov     [end_kernel_thunk+ebp], edi ; data we require for 'fixing' code section
    add     ebp, 04h

flt_next_iid: 
    add     edx, 14h                    ; point edx to next image_import_descriptor
    jmp     flt_scan4last_iid

;_________________________________________________________________________________________
