*****************************************************************************
*                                                                           *
*                       Data Encryption Systems Ltd.                        *
*                                                                           *
*                    Silver Street House, Silver Street                     *
*                        Taunton, Somerset, TA1 3DL                         *
*                            Tel: +44 (0)1823 352 357                       *
*                            Fax: +44 (0)1823 352 358                       *
*                         EMail : support@des.co.uk                         *
*                                                                           *
*****************************************************************************
*                                                                           *
* Program Title : Foxpro DK47 Demonstration           Version : 2.00        *
*                                                                           *
*****************************************************************************
* Author        Version     Comments                                 Date   *
*****************************************************************************
*                                                                           *
* Joseph Hickey   2.00   Initial Version.                          12/03/93 *
*                                                                           *
*****************************************************************************
set echo off
set talk off
set scoreboard off
set status off

clear

LOAD DK47Fox

* Constants

FindDk47= "0"
* checks for the presence of a dk47 on the bus

ResetDk47 ="1"
* resets the dk47

ReadbyteDk47 = "2"
* Reads a byte the dk47

ThroughEncryptDk47= "3"
* Encrypts a string with the random bytes from a Dk47. Call with the
* string to be encrypted, prefixed with a byte containing the length
* of the string
*   e.g. Call Dk47Fox with '3' + LEN(Mystring) + Mystring
* The string is then overwritten with the encrypted data

*************************************************************************

?''
?'DESkey Software Security System'
?'FoxPro Example and Demonstration Software for the Dk47'
?'Data Encryption Systems Limited'
?''

CALL Dk47Fox with FindDk47
* check for the presence of a DK47

IF FindDk47 = 'Y'
    Keyp = ' '
    DO WHILE Keyp <> chr(27)
        * If a Dk47 is present then get a command
        ?"Enter DK47 Command (? Help)"
        Keyp = CHR(INKEY(0,'h'))
        Keyp = UPPER(Keyp)
        DO CASE
            CASE Keyp = "H"
                DO Help
            CASE Keyp = "?"
                DO HELP
            CASE Keyp = "0"
                DO RandomNumbers
            CASE Keyp = "1"
                DO ThroughEncryption
        ENDCASE
    LOOP
    ENDDO
ELSE
    ?'DK47 Not present on the system '
    Waitkey = INKEY(0,'h')
ENDIF

*********************** Procedures ***************************************

PROCEDURE WriteHex
*Gives a String a Hex Representation

Hexy ='0123456789ABCDEF'
HexStr = ''

FOR Count = 1 TO LEN(ReadString)
    MyChar = SUBSTR(ReadString,Count,1)
* Take next char of the string

    MyByte = ASC(MyChar)
* Convert to a byte

HiNib = INT(MyByte/16)
* hi nibble of byte

HexStr = HexStr + SUBSTR(Hexy,HiNib+1,1)

LoNib = (MyByte - (HiNib*16))
LoNib = LoNib
* Lo nibble of byte
HexStr = HexStr + SUBSTR(Hexy,LoNib+1,1)
HexStr = HexStr + ' '

ENDFOR

?HexStr
?''
RETURN

**********************************************************************

PROCEDURE Help
* The Help Screen
?''
?''
?'FoxPro Example and Demonstration Software for the DK47'
?''
?'Dk47 Command Keys'
?'               0 - Read Random Numbers'
?'               1 - Demonstrate Encryption'
?''
?'Other Keys'
?'               h,? - This Help text'
?'               ESC - Quit.'
?''
?''
RETURN

********************************************************************

PROCEDURE RandomNumbers
?''
?'Read Random Numbers'
?''
ReadString = ''

Call Dk47Fox with ResetDk47

FOR Count = 1 TO 102

    CALL Dk47Fox with ReadByteDk47
    ReadString = Readstring + ReadbyteDk47
    ReadByteDk47 = '2'
LOOP
ENDFOR

DO  WriteHex
?''
RETURN
********************************************************************

PROCEDURE ThroughEncryption
?''
?'Demonstrate Through Encryption'
?''

MyString = 'This function demonstrates the Dk47s Encryption facility'
?MyString
?''

TEString = ThroughEncryptDk47 + CHR(LEN(MyString)) + MyString
* build a command string

CALL Dk47Fox with ResetDk47

* Reset the DK47

CALL Dk47Fox with TEString
* Call Through-encryption

MyString = RIGHT(TEString,LEN(TEString)-2)
?'The Encrypted string looks like this :'
?''
? MyString
?''

TEString = ThroughEncryptDk47 + CHR(LEN(MyString)) + MyString
CALL Dk47Fox with ResetDk47
CALL Dk47Fox with TEString

MyString = RIGHT(TEString,LEN(TEString)-2)
?'Decrypted : '
?''
? MyString
?''
?''

RETURN
*********************************************************************
