;*****************************************************************************
;*                                                                           *
;*                       Data Encryption Systems Ltd.                        *
;*                                                                           *
;*                    Silver Street House, Silver Street                     *
;*                        Taunton, Somerset, TA1 3DL                         *
;*                            Tel: +44 (0)1823 352 357                       *
;*                            Fax: +44 (0)1823 352 358                       *
;*                         EMail : support@des.co.uk                         *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;* Program Title : Assembler DK47 Driver               Version : 2.00        *
;*                                                                           *
;*****************************************************************************
;* Author        Version     Comments                                 Date   *
;*****************************************************************************
;*                                                                           *
;* Joseph Hickey   2.00   Initial Version.                          12/03/93 *
;*                                                                           *
;*****************************************************************************


datao       equ 200h                ; the location of the dk47's output

seedadd1    equ 201h
seedadd2    equ 202h                ; the location of the dk47's three seed bytes
seedadd3    equ 203h

;---------------------------------------------------------------------------

; finddk47 checks I/O location 200h for the presence of a dk47
; by reading 10 bytes from there. If they are all the same then
; there is no Dk47.

; If no Dk47 is found then this routine will set the carry flag

finddk47    proc    near

        push    ax
        push    cx
        push    dx

        mov cx,10

readl:      mov dx,datao
        in  al,dx                   ; read a byte from the Dk47
        mov ah,al                   ; store it in ah
        in  al,dx                   ; read another byte

        cmp al,ah                   ; see if they are equal
        jne dk47there               ; if they are different then a dk47 is present

        loop    readl

        pop dx
        pop cx
        pop ax

        stc                         ; if no dk47 is present then carry flag
        ret                         ; is set and we return

dk47there:  clc
        pop dx
        pop cx
        pop ax
        ret

finddk47    endp

;---------------------------------------------------------------------------

; seeddk47 resets the dk47 to a known point in its random number sequence
; using three seed bytes. These are passed in al (seed 1), ah (seed 2)
; and bl (seed 3)

seeddk47    proc    near

        mov dx,seedadd1
        out dx,al                   ; 'out' the bytes to the

        mov al,ah                   ; seed addresses

        mov dx,seedadd2
        out dx,al

        mov al,bl

        mov dx,seedadd3
        out dx,al

        ret

seeddk47    endp

;---------------------------------------------------------------------------

; readdk47 returns a byte from the dk47 in al

readdk47    proc    near

        push    dx

        mov dx,datao
        in  al,dx                   ; read the output of the Dk47

        pop dx

        ret
readdk47    endp

;---------------------------------------------------------------------------

; encdk47 takes the byte in ah, and XORs it with a byte from the dk47
; it returns the encrypted byte in ah

encdk47     proc    near

        push    dx

        mov dx,datao

        in  al,dx

        xor ah,al

        pop dx

        ret
encdk47     endp

;---------------------------------------------------------------------------
