;*****************************************************************************
;*                                                                           *
;*                       Data Encryption Systems Ltd.                        *
;*                                                                           *
;*                    Silver Street House, Silver Street                     *
;*                        Taunton, Somerset, TA1 3DL                         *
;*                            Tel: 01823 352 357                             *
;*                            Fax: 01823 352 358                             *
;*                            BBS: 01823 352 259                             *
;*                   EMail : deskey@silver.cityscape.co.uk                   *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;* Program Title : Assembler DK47 Demonstration        Version : 2.00        *
;*                                                                           *
;*****************************************************************************
;* Author        Version     Comments                                 Date   *
;*****************************************************************************
;*                                                                           *
;* Joseph Hickey   2.00   Initial Version.                          12/03/93 *
;*                                                                           *
;*****************************************************************************

;----------------------------------------------------------------------------

		.model	large
		.stack	20h
		.code

		include	dk47.asm
		include	hexit.asm

;--------------------------------------------------------------------------

seedbyte1	equ	9	; these three bytes are used to reset or
seedbyte2	equ	9	; 'seed' the dk47 to a known place in its
seedbyte3	equ	9	; random number sequence. They can set to
				; any value.

;--------------------------------------------------------------------------

main:		call	cls		; clear the screen

		call	message1

		call	checkdk47       ; check for a DK47 (this routine drops
					; out if a DK47 can't be found)
loops:		call	message2

		mov	ah,8            ; read the keyboard
		int	21h

		cmp	al,'h'
		je	helps
		cmp     al,'H'          ; if 'h' or '?' was pressed then
		je	helps           ; show the help screen
		cmp	al,'?'
		je	helps

		cmp	al,'0'          ; function '0' - read random numbers
		je	rndnoss

		cmp	al,'1'          ; function '1' - encryption
		je	encs

		cmp	al,27           ; escape quits
		je	escape

		jmp	loops           ; jump back for to read the keyboard
				      	; again

;--------------------------------------------------------------------------

helps:		call	help
		jmp	loops

rndnoss:	call	rndnos
		jmp	loops
					; call the routines then jump back
encs:		call	enc       	; to the main loop
		jmp	loops

escape:		mov	ax,4c00h        ; escape quits
		int	21h

;--------------------------------------------------------------------------

mess1:		db	10,13,'DESkey Sotware Security System'
		db	10,13,'Assembler Example and Demonstration Software for the DK47'
		db	10,13,'Data Encryption Systems Limited',13,10,'$'

message1	proc	near		; writes a message on the screen

		push	cs
		pop	ds
		mov	dx,offset cs:mess1
		mov	ah,9
		int	21h

		ret
message1	endp

;--------------------------------------------------------------------------

mess2:		db	13,10,'Enter DK47 Command (? Help)',13,10,'$'

message2	proc	near            ; writes a message on the screen

		push	cs
		pop	ds
		mov	dx,offset cs:mess2
		mov	ah,9
		int	21h

		ret
message2	endp

;-------------------------------------------------------------------------

nodk47m:	db	13,10,'DK47 Not Present on the System',13,10,'$'

checkdk47	proc	near

		clc
		call	finddk47	; find dk47 sets the carry flag if
					; a dk47 is not present
		jnc	ok              ; if the carry flag is clear then continue

		push	cs              ; display a message and quit to dos
		pop	ds              ; if the carry flag is set
		mov	dx,offset cs:nodk47m
		mov	ah,9
		int	21h

		mov	ax,4c00h
		int	21h

ok:		ret
checkdk47	endp

;--------------------------------------------------------------------------

rndmess:	db	13,10,'Read Random Numbers',13,10,'$'

rndnos		proc	near

		push	cs
		pop	ds
		mov	dx,offset cs:rndmess    ; write a message on screen
		mov	ah,9
		int	21h

		mov	al,seedbyte1		; seed the Dk47
		mov	ah,seedbyte2
		mov	bl,seedbyte3
		call	seeddk47

		mov	cx,200
loopa: 		call	readdk47		; display 200 random numbers
		call	hexit
		call	twospace
		loop	loopa

		ret
rndnos		endp

;--------------------------------------------------------------------------

emess:		db	13,10,'Through Encryption',13,10
es$:		db	13,10,'The Random Bytes from a DK47 are useful for '
	 	db	      'very high speed Encryption.',13,10,'$'
emess1:		db	13,10,'The Encrypted string looks like this :',13,13,10,'$'
emess2:		db	13,10,'Decrypted :$'


enc		proc	near

		push	cs
		pop	ds
		mov	dx,offset cs:emess
		mov	ah,9
		int	21h

		mov	al,seedbyte1		; seed the Dk47 so we are able
		mov	ah,seedbyte2		; to seed it again in order that
		mov	bl,seedbyte3		; decryption will work
		call	seeddk47

		mov	si,offset cs:es$	; encrypt string es$
		mov	cx,71
tloop:		mov	ah,cs:[si]
		call	encdk47
		mov	cs:[si],ah

		inc	si

		loop	tloop

		push	cs                      ; write it on the screen
		pop	ds
		mov	dx,offset cs:emess1
		mov	ah,9
		int	21h
		mov	dx,offset cs:es$
		int	21h

		mov	al,seedbyte1		; seed the dk47 with the same
		mov	ah,seedbyte2            ; seed, so the decryption
		mov	bl,seedbyte3            ; will work
		call	seeddk47

		mov	si,offset cs:es$	; dencrypt es$
		mov	cx,71
tloop1:		mov	ah,cs:[si]
		call	encdk47
		mov	cs:[si],ah

		inc	si

		loop	tloop1

		push	cs                      ; write it on the screen
		pop	ds
		mov	dx,offset cs:emess2
		mov	ah,9
		int	21h
		mov	dx,offset cs:es$
		int	21h

		ret
enc		endp

;--------------------------------------------------------------------------

helpmess:	db	13,10,'Assembler Example and Demonstration Software for the DK47'
		db	13,10
		db	13,10,'DK47 Command Keys'
		db	13,10
		db	13,10,'                 0 - Read Random Numbers'
		db	13,10,'                 1 - Demonstrate Encryption'
		db	13,10
		db	13,10,'       Other Keys'
		db	13,10
		db	13,10,'               h,? - Show this Text'
		db	13,10,'               esc - Quit',13,10,'$'

help		proc	near

		push	cs
		pop	ds
		mov	dx,offset cs:helpmess
		mov	ah,9
		int	21h

		ret
help		endp

;--------------------------------------------------------------------------

end		main
