/*****************************************************************************/
/*                                                                           */
/*                       Data Encryption Systems Ltd.                        */
/*                                                                           */
/*                    Silver Street House, Silver Street                     */
/*                        Taunton, Somerset, TA1 3DL                         */
/*                            Tel: +44 (0)1823 352 357                       */
/*                            Fax: +44 (0)1823 352 358                       */
/*                          EMail: support@des.co.uk                         */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/* Program Title : DK47 C Driver                       Version : 2.00        */
/*                                                                           */
/*****************************************************************************/
/* Author        Version     Comments                                 Date   */
/*****************************************************************************/
/*                                                                           */
/* Joseph Hickey   2.00   Initial Version.                          02/01/93 */
/*                                                                           */
/*****************************************************************************/

#include <dos.h>
#include "dk47.h"

/*
 * SeedDk47 resets the Dk47 to a known point on its number line
 * by 'out'ing the three bytes passed as parameters to locations
 * 0x201,0x202 & 0x203
 *
 */

void SeedDk47 (unsigned char s1,unsigned char s2,unsigned char s3)
{
    outp(0x201,s1);
    outp(0x202,s2);
    outp(0x203,s3);
}

/*
 * FindDk47 checks for the presence of a dk47 on the system.
 *
 * It returns 1 if a  Dk47 is found, else returns 0
 *
 */

int FindDk47( void )
{
    int count = 10;

    while( count-- )

        if( inp(0x200) != inp(0x200) ) return 1;

    return 0;

}

/*
 * ReadDk47 returns a byte read from a Dk47
 *
 */

unsigned char ReadDk47( void )
{
    return inp( 0x200 );
}

/*
 * Encrypt encrypts a string with the random bytes from a Dk47
 *
 * pass the string and the string length. The string is then
 *
 * over written with the encrypted version
 *
 */

void Encrypt( int Length, unsigned char *stringpointer )
{
    while( Length-- )
    {
        *stringpointer ^= ReadDk47();
        stringpointer++;
    }
}
