/*****************************************************************************/
/*                                                                           */
/*                       Data Encryption Systems Ltd.                        */
/*                                                                           */
/*                    Silver Street House, Silver Street                     */
/*                        Taunton, Somerset, TA1 3DL                         */
/*                            Tel: +44 (0)1823 352 357                       */
/*                            Fax: +44 (0)1823 352 358                       */
/*                         EMail : support@des.co.uk                         */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/* Program Title : DK47 C Demonstration                Version : 2.00        */
/*                                                                           */
/*****************************************************************************/
/* Author        Version     Comments                                 Date   */
/*****************************************************************************/
/*                                                                           */
/* Joseph Hickey   2.00   Initial Version.                          02/01/93 */
/*                                                                           */
/*****************************************************************************/

#include "dk47.c"
#include <stdio.h>
#include <string.h>
#include <conio.h>

unsigned char SeedByte1 = 0x90;
unsigned char SeedByte2 = 0x90;
unsigned char SeedByte3 = 0x90;


/**************************************************/

void Help( void )
{
    printf("\n");
    printf("\n'C' Dk47 Demonstration Program.            D.E.S. Ltd. 1993");
    printf("\n");
    printf("\nDk47 Command Keys :");
    printf("\n");
    printf("\n                0 : Read Random Numbers.");
    printf("\n                1 : Demonstrate Encryption.");
    printf("\n");
    printf("\n       Other Keys :");
    printf("\n");
    printf("\n              h,? : Display this text.");
    printf("\n              esc : Quit.");
    printf("\n");
}

/**************************************************/


void RandomNumbers( void )
{
    int count = 200;

    printf("\n");
    printf("\nRead Random Numbers  :\n");
    printf("\n");

    SeedDk47( SeedByte1, SeedByte2, SeedByte3 );

    while( count-- )


        printf("%02X  ", ReadDk47() );

    printf("\n");
}

/**************************************************/

void DoEncryption( void )
{
    int Length;
    char MyString[] = "The Random Bytes from a Dk47 are useful for very high speed Encryption.";

    printf("\n");
    printf("\nDemonstrate Encryption.");
    printf("\n");

    Length = strlen( MyString );

    printf("\nBefore Encryption :\n");
    printf( MyString );

    SeedDk47( SeedByte1, SeedByte2, SeedByte3 );
    Encrypt( Length, MyString );

    printf("\n\nAfter Encryption :\n");
    printf(MyString,"\n");

    SeedDk47( SeedByte1, SeedByte2, SeedByte3 );
    Encrypt( Length, MyString );

    printf("\n\nDencrypted :\n");
    printf(MyString,"\n");
    printf("\n");
    printf("\n");
}

/**************************************************/

void main(void)
{
    char key;

    printf("\nDESkey Software Security System");
    printf("\nC Example and Demonstration Code for the Dk47");
    printf("\nData Encryption Systems Limited.\n");

    if( FindDk47() )
    {
        while( key != 27 )
        {
            printf("\nEnter Dk47 Command (? Help) :");

            key = getch();

            switch( key )
            {
                case 'h': Help(); break;
                case 'H': Help(); break;
                case '?': Help(); break;

                case '0': RandomNumbers();break;

                case '1': DoEncryption();break;
            }
        }
    }
    else
        printf("\nDk47 Not Present on the System.\n");

}













