'*****************************************************************************
'*                                                                           *
'*                       Data Encryption Systems Ltd.                        *
'*                                                                           *
'*                    Silver Street House, Silver Street                     *
'*                        Taunton, Somerset, TA1 3DL                         *
'*                            Tel: +44 (0)1823 352 357                       *
'*                            Fax: +44 (0)1823 352 358                       *
'*                   EMail : support@des.co.uk                               *
'*                                                                           *
'*****************************************************************************
'*                                                                           *
'* Program Title : QBasic DK47 Demonstration           Version : 2.00        *
'*                                                                           *
'*****************************************************************************
'* Author        Version     Comments                                 Date   *
'*****************************************************************************
'*                                                                           *
'* Joseph Hickey   2.00   Initial Version.                          12/03/93 *
'*                                                                           *
'*****************************************************************************
'Version 2.00

DECLARE FUNCTION FindDk47! ()                   ' checks for the presence of a Dk47
DECLARE SUB ResetDk47 ()                        ' resets a Dk47
DECLARE SUB Help ()                             ' help screen
DECLARE SUB RandomNums ()                       ' displays random numbers from the Dk47
DECLARE SUB DoThruEnc ()                        ' demonstrates encryption
DECLARE FUNCTION ThroughEncrypt% (Byte%)        ' encryption function
DECLARE FUNCTION ReadByteDk47 ()                ' reads a byte from a Dk47

COMMON SHARED SeedByte1, SeedByte2, SeedByte3

SeedByte1 = 50
SeedByte2 = 50
SeedByte3 = 50

CLS
PRINT
PRINT "DESkey Software Security System"
PRINT "Quick Basic Example and Demonstration Software for the Dk47"
PRINT "Data Encryption Systems"
PRINT

IF FindDk47! THEN

    DO
        PRINT "Enter Dk47 Command :"

        DO
            Key$ = INKEY$
        LOOP UNTIL Key$ <> ""

        SELECT CASE Key$

            CASE "h", "H", "?"
                Help
            CASE "0"
                RandomNums
            CASE "1"
                DoThruEnc
        END SELECT

    LOOP UNTIL Key$ = CHR$(27)

ELSE
        PRINT "Dk47 Not Present on any Parallel Ports"
END IF

SUB DoThruEnc
    
    PRINT
    PRINT "Demonstrate Encryption :"
    PRINT
    
    Orig$ = "This Function demonstrates the Dk47's Encryption Facility"
    
    PRINT Orig$
    PRINT
    
    ResetDk47                                       ' reset Dk47
    
    FOR Loops = 1 TO LEN(Orig$)
        OldByte% = ASC(MID$(Orig$, Loops, 1))
        NewByte% = ThroughEncrypt(OldByte%)         ' encrypt each byte of the string
        MID$(Orig$, Loops, 1) = CHR$(NewByte%)
    NEXT Loops
    
    PRINT "After Encryption :"
    
    FOR Loops = 1 TO LEN(Orig$)
        IF ASC(MID$(Orig$, Loops, 1)) > 31 THEN PRINT MID$(Orig$, Loops, 1);  ELSE PRINT ".";
    NEXT Loops             ' N.B. Control characters are displayed as full stops
    
    PRINT
    PRINT
    PRINT "Decrypted :"
    
    ResetDk47               ' Dk47 must be reset to the same point on its random numbers line
    
    FOR Loops = 1 TO LEN(Orig$)
        OldByte% = ASC(MID$(Orig$, Loops, 1))
        NewByte% = ThroughEncrypt(OldByte%)     ' decrypt each byte
        MID$(Orig$, Loops, 1) = CHR$(NewByte%)
    NEXT Loops
    
    FOR Loops = 1 TO LEN(Orig$)
        IF ASC(MID$(Orig$, Loops, 1)) > 31 THEN PRINT MID$(Orig$, Loops, 1);  ELSE PRINT ".";
    NEXT Loops
    
    
    PRINT
    PRINT
END SUB

FUNCTION FindDk47

    FindDk47 = 0
    
    OUT &H201, SeedByte1
    OUT &H202, SeedByte2
    OUT &H203, SeedByte3
    
    Count = 0
    
    DO
        a = INP(&H200)
        b = INP(&H200)
        Count = Count + 1
    
        IF a <> b THEN FindDk47 = 1
    
    LOOP UNTIL (Count = 10) OR Findd47 = 1

END FUNCTION

SUB Help

    PRINT
    PRINT "Quick Basic Exapmle and Demonstration Software for the Dk47"
    PRINT
    PRINT "Dk47 Command Keys"
    PRINT
    PRINT "                 0 - Read Random Numbers"
    PRINT "                 1 - Demonstrate Encryption"
    PRINT
    PRINT "        Other Keys"
    PRINT
    PRINT "                h,? - Show this Text"
    PRINT "                esc - Quit"
    PRINT

END SUB

SUB RandomNums
    
    PRINT
    PRINT "Read Random Numbers"
    PRINT
    
    
    ResetDk47                                       ' reset the Dk47
    
    FOR Count = 1 TO 200
    
        Byte = ReadByteDk47
        IF Byte < 16 THEN PRINT "0";                ' display 200 random bytes in hex format with
        PRINT HEX$(Byte); "  ";                     ' leading zeros
    
    NEXT Count
    
    
    PRINT
    PRINT
END SUB

FUNCTION ReadByteDk47                           ' reads a byte from a Dk47

    ReadByteDk47 = INP(&H200)                   ' return the byte read

END FUNCTION

SUB ResetDk47                                   ' resets a Dk47

    OUT &H201, SeedByte1
    OUT &H202, SeedByte2
    OUT &H203, SeedByte3

END SUB

FUNCTION ThroughEncrypt% (Byte%)

    ThroughEncrypt% = Byte% XOR ReadByteDk47    ' software encryption ie XORs a byte with a random byte from the Dk47

END FUNCTION

