(*****************************************************************************)
(*                                                                           *)
(*                       Data Encryption Systems Ltd.                        *)
(*                                                                           *)
(*                    Silver Street House, Silver Street                     *)
(*                        Taunton, Somerset, TA1 3DL                         *)
(*                            Tel: +44 (0)1823 352 357                       *)
(*                            Fax: +44 (0)1823 352 358                       *)
(*                         EMail : support@des.co.uk                         *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(* Program Title : Turbo Pascal DK47 Driver            Version : 2.00        *)
(*                                                                           *)
(*****************************************************************************)
(* Author        Version     Comments                                 Date   *)
(*****************************************************************************)
(*                                                                           *)
(* Duncan Hume     2.00   Initial Version.                          15/07/91 *)
(*                                                                           *)
(*****************************************************************************)
UNIT Dk47;

INTERFACE

FUNCTION Find_DK47 : BOOLEAN;
PROCEDURE Seed_Dk47( Seed1, Seed2, Seed3 : BYTE);
FUNCTION ReadByte_DK47 : BYTE;
FUNCTION Encrypt_DK47( s : STRING) : STRING;

IMPLEMENTATION

CONST
   DataOut  = $200;
   SeedAddr = $201;

FUNCTION Find_DK47 : BOOLEAN;

TYPE
    Numbers = ARRAY[1..10] OF BYTE;

VAR
    Count : BYTE;
    Check : BYTE;
    CheckNos : Numbers;
    Dk47there: BOOLEAN;
{

 To check for the presence of a Dk47, we read 10 bytes from I/O

address $200. If they are all the same then there is no Dk47

on the bus.

}

BEGIN

    FInd_Dk47 := FALSE;
    Seed_DK47( 1, 1, 1 );

    Check := 0;

    FOR Count := 1 TO 10 DO

        CheckNos[ Count ] := Readbyte_Dk47;

    FOR Count := 1 TO 9 DO

        IF CheckNos[ Count ] = CheckNos[ Count + 1 ] THEN Check := Check + 1;

    IF Check <> 9 THEN Find_Dk47 := TRUE;

END;


(* Reset and Seed the DK47 *)
PROCEDURE Seed_Dk47( Seed1, Seed2, Seed3 : BYTE);

BEGIN
     Port[ SeedAddr ]   := Seed1;
     Port[ SeedAddr+1 ] := Seed2;
     Port[ SeedAddr+2 ] := Seed3;
END;

(* Read Byte from the DK47 *)
FUNCTION ReadByte_DK47 : BYTE;

BEGIN
     ReadByte_DK47 := Port[ DataOut ];
END;

FUNCTION Encrypt_DK47( s : STRING) : STRING;
VAR
   enc : STRING;
   loop : INTEGER;
BEGIN
     enc := '';
     FOR loop := 1 TO length(s) DO
         enc := enc + chr( ord(s[loop]) XOR Port[ DataOut ]);
     Encrypt_DK47 := enc;
END;

BEGIN
END.
