(*****************************************************************************)
(*                                                                           *)
(*                       Data Encryption Systems Ltd.                        *)
(*                                                                           *)
(*                    Silver Street House, Silver Street                     *)
(*                        Taunton, Somerset, TA1 3DL                         *)
(*                            Tel: 01823 352 357                             *)
(*                            Fax: 01823 352 358                             *)
(*                            BBS: 01823 352 259                             *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(* Program Title : Turbo Pascal DK47 Demonstration     Version : 2.00        *)
(*                                                                           *)
(*****************************************************************************)
(* Author        Version     Comments                                 Date   *)
(*****************************************************************************)
(*                                                                           *)
(* Joseph Hickey   2.00   Initial Version.                          12/03/93 *)
(*                                                                           *)
(*****************************************************************************)
USES

    DK47,CRT,HEXIT;

CONST

    Seed1 = 9;      { The Dk47 has three seed bytes, which take it to }
    Seed2 = 9;      { a known place in its random number sequence     }
    Seed3 = 9;      { these can, of course, be any bytes you choose   }

PROCEDURE Rand_Nos;

VAR
    Count : BYTE;

BEGIN

    WRITELN;
    WRITELN('Read Random Numbers');
    WRITELN;

    Seed_DK47(Seed1,Seed2,Seed3);       { seed the Dk47 with the three bytes }

    FOR Count := 1 TO 200 DO

        WRITE(Hex(Readbyte_DK47),'  '); { display 200 bytes from the DK47    }

    WRITELN;

END;

PROCEDURE Encrypt;

VAR
    aString : STRING;

BEGIN

    WRITELN;
    WRITELN('Encryption');
    WRITELN;

    aString := 'The Random Bytes from a Dk47 are useful for very high speed Encryption';

    WRITELN(aString);
    WRITELN;

    Seed_DK47(Seed1,Seed2,Seed3);    { we must have a common starting point  }
    aString := Encrypt_Dk47(aString);{ before we encrypt, or we will never be}
                                         { able to decrypt.                      }
    WRITELN('After Encryption :');
    WRITELN(aString);
    WRITELN;

    Seed_DK47(Seed1,Seed2,Seed3);    { Re-seed the Dk47 to the same place for}
    aString := Encrypt_Dk47(aString);{ decryption.                           }

    WRITELN('After Decryption :');
    WRITELN(aString);
    WRITELN;

END;

PROCEDURE Help;

BEGIN
    WRITELN;
    WRITELN('Turbo Pascal and Demonstration Software for the DK47');
    WRITELN;
    WRITELN('DK12 Command Keys');
    WRITELN;
    WRITELN('                 0 - Read Random Numbers');
    WRITELN('                 1 - Demonstrate Encryption');
    WRITELN;
    WRITELN('       Other Keys');
    WRITELN;
    WRITELN('               h,? - Show this Text');
    WRITELN('               esc - Quit');
    WRITELN;
END;

VAR
    Key : CHAR;

BEGIN
    CLRSCR;
    WRITELN;
    WRITELN('DESkey Software Security System');
    WRITELN('Turbo Pascal Example and Demonstration Software for the DK47');
    WRITELN('Data Encryption Systems');
    WRITELN;

    IF Find_Dk47 = TRUE THEN

    BEGIN

        REPEAT

            WRITELN('Enter Dk47 Command (? Help)');

            REPEAT
            UNTIL KEYPRESSED;

            Key := READKEY;

            CASE Key OF

                'h','H','?': Help;

                '0': Rand_Nos;

                '1': Encrypt;

            END;

        UNTIL Key = CHR(27);

    END
    ELSE

            WRITELN('DK47 Not Present');

END.
