
{Hasp dumper, written 1998 by stpark, original method by bajunny}

{$A+,B-,E+,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 2048, 0 , 2048}
uses misc;
const
(*
 * A list of the HASP services
 *)
   IS_HASP                      =  1;
   GET_HASP_CODE                =  2;
   READ_MEMO                    =  3;
   WRITE_MEMO                   =  4;
   GET_HASP_STATUS              =  5;
   GET_ID_NUM                   =  6;
   READ_MEMO_BLOCK              = 50;
   WRITE_MEMO_BLOCK             = 51;

(*
 * A list of the TimeHASP services
 *)
   TIMEHASP_SET_TIME            = 70;
   TIMEHASP_GET_TIME            = 71;
   TIMEHASP_SET_DATE            = 72;
   TIMEHASP_GET_DATE            = 73;
   TIMEHASP_WRITE_MEMORY        = 74;
   TIMEHASP_READ_MEMORY         = 75;
   TIMEHASP_WRITE_MEMORY_BLOCK  = 76;
   TIMEHASP_READ_MEMORY_BLOCK   = 77;
   TIMEHASP_GET_ID_NUM          = 78;

(*
 * A list of NetHASP services.
 *)
   NET_LAST_STATUS              = 40;
   NET_GET_HASP_CODE            = 41;
   NET_LOGIN                    = 42;
   NET_LOGOUT                   = 43;
   NET_READ_WORD                = 44;
   NET_WRITE_WORD               = 45;
   NET_GET_ID_NUMBER            = 46;
   NET_READ_MEMO_BLOCK          = 52;
   NET_WRITE_MEMO_BLOCK         = 53;

   OK                           = 0;
   NET_READ_ERROR               = 131;
   NET_WRITE_ERROR              = 132;


(*
 * A list of LptNum codes for different key types
 *)
   LPT_IBM_ALL_HASP25  = 0;
   LPT_IBM_ALL_HASP36  = 50;
   LPT_NEC_ALL_HASP36  = 60;

   MEMO_BUFFER_SIZE  = 56;
   MAX_COUNT         = $FFFF;

  First  = $1989;
  Second = $0108;
  strobe : byte = $9C;

  Debug  : Boolean = False;

  Default : array [0..14] of byte = ($8a, $f8, $da, $ba, $94, $c8, $a8, $80,
                                     $92, $d0, $b0, $8c, $9E, $dc, $bc);
  Tmp     : array [0..14] of byte = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
  Filler  : array [0..5]  of byte = ($40, $20, $10, $08, $04, $02);
  Pair1   : array [0..14] of byte = ($40,
                                     $40, $20,
                                     $40, $20, $10,
                                     $40, $20, $10, $08,
                                     $40, $20, $10, $08, $04);
  Pair2   : array [0..14] of byte = ($20,
                                     $10, $10,
                                     $08, $08, $08,
                                     $04, $04, $04, $04,
                                     $02, $02, $02, $02, $02);
type
    tarrbyte     = array [byte] of byte;
    parrbyte     = ^tarrbyte;
    Dump         = record
    pass1, pass2 : word;
    table        : array  [0..7] of byte;
    sn           : array  [0..7] of word;
    eeprom       : array [0..MEMO_BUFFER_SIZE-1] of word;
    end;

var
  HASB    : Dump;
  LPT      : word absolute $40:$08;
  z1, z2   : integer;
  tab      : array [0..63] of byte;
  f        : file;
  s        : string;
  n        : word;

  x, y, i, j, k, found    : integer;
  pwd1, pwd2   : word;
  p1,p2,p3,p4      : integer;
  Service          : word;
  tmp_mask, mask   : byte;
  xor_mask, passwds: longint;
  ID: longint;
{$L hasptp.obj}
{$F+}
procedure  hasp (Service, SeedCode, LptNum, Pass1, Pass2 : integer;
                 var p1,p2,p3,p4 : integer);external;
{$F-}

function spc(num:byte; c:char):string;
var
   s : string;
begin
     FillChar(s[1], num, c); s[0]:=chr(num); spc:=s;
end;

procedure OutByte(i:byte);
begin
  port[LPT] := i;
  port[LPT] := i or 1;
end;

function HASPOut:byte;
begin
     HASPOut:=ord((port[LPT+1] and 32) <> 0);
end;

function Bitcode(i : byte) : byte;
begin
  Port[LPT] := i or 128;
  Bitcode := HASPout;
end;

procedure OpenMemo;
var
   i : integer;
begin
  port[LPT+2]:=$0C;
  outbyte($C6);
  for i:=0 to 13 do
      outbyte(tmp[i]);
end;

procedure CloseHASP;
begin
  outbyte($C6);
end;

procedure TeaseBit(t, b : integer);
var
   teaser : integer;
begin
  teaser := 1 shl b;
  if t>0 then
      strobe:=strobe or teaser
  else
      strobe:=strobe and (teaser xor 255);
  port[LPT]:=strobe;
end;

procedure SendWord(cmd:word; len:integer);
begin
  repeat
    TeaseBit( cmd and (1 shl (len-1)), 6);
    TeaseBit( 1, 5);
    TeaseBit( 0, 5);
    dec(len);
  until len=0;
end;

function ReadWord:word;
var
  i   : integer;
  res : word;
begin
  res := 0;
  TeaseBit(1,5);
  TeaseBit(0,5);
  for i:=16 downto 0 do
  begin
    res := res or (HASPOut shl (i-1));
    TeaseBit(1,5);
    TeaseBit(0,5);
  end;
  ReadWord := res;
end;

function GetResult(cmd : parrbyte) : word;
var
  i, j, res : integer;
begin
  port[LPT+2] := $C;
  CloseHASP;
  for i := 0 to 13 do
      outbyte(cmd^[i]);
  res := port[LPT+1] shr 8;
  outbyte(cmd^[14]);
  res := res or port[LPT+1];
  z2 := 0;
  for j := 0 to 63 do
      inc(z2, bitcode(j shl 1));
  if (z2 <> 0) and (z2 <> 64) and (z2 <> z1) then res := $5f5f;
  GetResult := res;
end;

function TryPairIndex(n : integer) : byte;
var
  tmp1, tmp2 : array [0..14] of byte;
  i, res : integer;
begin
  move(tmp, tmp1, sizeof(tmp));  move(tmp, tmp2, sizeof(tmp)); res:=0;
  for i := 0 to 14 do
  begin
      tmp1[n] := tmp1[n] xor pair1[i]; tmp2[n] := tmp2[n] xor pair2[i];
      if (GetResult(@tmp1) = $5f5f) and
         (GetResult(@tmp2) = $5f5f) then
          if ((n=7) or (n=3)) and (i+1=$F) then res:=0 else res:=i+1;
      tmp1[n] := tmp1[n] xor pair1[i]; tmp2[n] := tmp2[n] xor pair2[i];
  end;
  TryPairIndex := res;
end;

procedure ShowTable;
var
    I : integer;
begin
    For i:=0 to 63 do
    begin
       write(tab[i], ' ');
       if i and 7 = 7 then writeln;
    end;
end;

procedure NoHasp;
begin
     WriteLn(' There is no HASP in LPT, or LPT port is wrong ('+HexW(LPT)+'h)!');
     Halt(255);
end;

procedure DumpHASPMemory;
begin
(*
 * Read Memory Block
 *)
    for i := 1 to MEMO_BUFFER_SIZE do HasB.eeprom[i] := 0;

    p1 := 0;                     {memory start address}
    p2 := MEMO_BUFFER_SIZE;      {block length}
    p3 := Seg(HasB.eeprom);
    p4 := Ofs(HasB.eeprom);
    Service:=READ_MEMO_BLOCK;
    hasp ( Service, 0, 0, Pwd1, Pwd2, p1, p2, p3, p4 );


{    if p3 <> 0 then begin
       writeln('Read Block operation failed. Error number: ',p3);
      end;
}
    if p3=0 then begin
      s:=Hexw(pwd1)+HexW(pwd2)+'.HSP';
      assign(f, s);
      rewrite(f,1);
      HASB.pass1:=pwd1;
      HASB.pass2:=pwd2;

      p1 := 0;
      p2 := 0;
      Service := GET_ID_NUM;
      hasp ( Service, 0, 0, Pwd1, Pwd2, p1,p2,p3,p4 );

      HASB.sn[0]:=p2;
      HASB.sn[1]:=p1;

      BlockWrite(f, HASB, SizeOf(HASB));
      close(f);
      WriteLn(#13#10' Dump written to file '+S);
      halt(1);
   end;
end;

begin
  If paramstr(1)=HexW(First)+HexW(Second) then Debug:=True;
  WriteLn('HASP dumber v 3.0 by MeteO, KrK, Fixit');
  Writeln('based on stpark code (original method by bajunny)');
  found := -1;
  z1 := 0;

  GetResult(@Default);

  for i := 0 to 63 do
      begin
           tab[i] := bitcode(i shl 1);
           inc(z1, tab[i]);
           if tab[i]=0 then Found:=0;
      end;

  If found=-1 then NoHasp else Found:=-1;

  If Debug Then Showtable;

  move(Default, tmp, sizeof(Default)); tmp[13] := Strobe;
  for i := 0 to 15625 {5^6} do
  begin
    Write(' Search in progress: ', Round(i/15625*100),'%   ',#13);
    k:=i;
    for j := 8 to 12 do
    begin
        tmp[j] := filler[k mod 5] xor Default[j]; k := k div 5;
    end;
    tmp[14] := filler[k mod 5] xor Default[14];
    if GetResult(@tmp) = $5F5F then found:=I;
  end;
  WriteLn;

  k := found;
  for j := 8 to 12 do begin
    tmp[j] := filler[k mod 5] xor Default[j];
    k := k div 5;
  end;
  tmp[14] := filler[k mod 5] xor Default[14];

  HASB.pass1:=(TryPairIndex(3) shl 12)+(TryPairIndex(2) shl 8)+
              (TryPairIndex(1) shl 4)+TryPairIndex(0);
  HASB.pass2:=(TryPairIndex(7) shl 12)+(TryPairIndex(6) shl 8) +
              (TryPairIndex(5) shl 4)+TryPairIndex(4);

  HASB.pass1:=HASB.pass1 xor First;
  HASB.pass2:=HASB.pass2 xor Second;

  If (HASB.pass1=First) or (HASB.pass2=Second) then NoHASP;

  if Debug then
     writeln('HASP passwords: ', hexw(HASB.pass1), ' ', hexw(HASB.pass2));

  GetResult(@tmp);
  for i := 0 to 63 do
    tab[i] := bitcode(i shl 1);

  if Debug then ShowTable;

  i:=0; FillChar(HASB.Table, SizeOf(HASB.Table), 0);
  for j:=0 to 7 do
      for k:=0 to 7 do
          begin
               HASB.Table[j]:=HASB.Table[j] or tab[i] shl (7-k);
               inc(i);
          end;
  CloseHASP;
  mask:=0;

  for x:=0 to $ff do begin
  passwds := HASB.pass1 * $10000 + HASB.pass2;
  xor_mask :=0;
      for y:=0 to 7 do begin
      tmp_mask := mask;
      tmp_mask := ((tmp_mask shr y) and 1);
      if tmp_mask = 1 then begin
       xor_mask := xor_mask or longint($f shl longint(y*4));
         end;
         end;
passwds := passwds xor xor_mask;

   pwd1:=passwds div $10000;
   pwd2:=passwds and $ffff;
   write(#13,hexw(pwd1),':',hexw(pwd2),'--',hexd(xor_mask));
  DumpHASPMemory;
  mask:=mask+1;
  end;

End.
