; Sentinel NSLMS emulation library by MeteO
; contact address: meteo@null.net
;
;
;***************************************************************************
;*                                netinel.inc                              *
;***************************************************************************

;***************************************************************************
;*            ERROR CODES returned by the client interface routines        *
;***************************************************************************
CL_SUCCESS                      = (  0)
NN_SERVER_NOT_FOUND             = ( -1)
NN_INVALID_CONNECTION           = ( -2)
NN_ALGO_NOT_FOUND               = ( -3)
NN_OUT_OF_HANDLES               = ( -4)
NN_HANDLE_ALREADY_LOCKED        = ( -5)
NN_HANDLE_LOCKED                = ( -6)
NN_INVALID_FUNCTION             = ( -7)
NN_INVALID_UNIT                 = ( -8)
CL_RPC_ERROR                    = ( -9)
CL_ALGO_NOT_FOUND               = (-10)
CL_OUT_OF_HANDLES               = (-11)
CL_NO_NETINEL_SERVERS           = (-12)
CL_BAD_HANDLE                   = (-13)
CL_NO_MORE_KEYS                 = (-14)
CL_HANDLE_LOCKED                = (-15)
CL_HANDLE_ALREADY_LOCKED        = (-16)
CL_SERVER_DIED                  = (-17)
CL_SERVER_PROTOCOL              = (-18)
CL_NETWORK_INIT                 = (-19)
CL_SERVER_NOT_FOUND             = (-20)
CL_CANNOT_CONNECT               = (-21)
CL_SERVER_BUSY                  = (-22)
NN_KEY_REMOVED                  = (-23)
CL_CLIENT_BUSY                  = (-24)
CL_TASK_TABLE_FULL              = (-25)
CL_API_ERROR                    = (-26)
CL_INVALID_REQUEST              = (-27)
CL_INVALID_HANDLE_TBL_REQ       = (-28)
CL_MEMORY_ALLOCATION_ERR        = (-29)
CL_VERSION_NOT_SUPPORTED        = (-30)
CL_LOADER_NOT_INSTALLED         = (-31)
CL_UNSUPPORTED_PROTOCOL         = (-32)
CL_ASL_OPTION_NOT_AVAILABLE     = (-33)
CL_ASL_MAX_LICENSE_REACHED      = (-34)
CL_ASL_LICENSE_TABLE_FULL       = (-35)
CL_ASL_KEY_REMOVED              = (-36)
CL_ASL_KEY_CONTENT_CHANGED      = (-37)
CL_ASL_OUT_OF_RANGE             = (-38)
CL_ASL_NOT_INUSE_BY_YOU         = (-39)
CL_INVALID_ASLCMD               = (-40)
CL_ASL_RSP_PTR_NULL             = (-41)
CL_INVALID_SUBLICENSE           = (-42)
CL_FNCT_NOT_AVAIL_IN_LOCAL_MODE = (-43)
NN_BAD_HANDLE                   = (-47)


;***************************************************************************
;*                              equates section                            *
;***************************************************************************

QUERY_DATA_SIZE            =   64           ;* size of a block for query_key()
QC_READ_OP                 =    1           ;* values for C_CMD_BLOCK
QC_HIGH_WATER              =   60
QC_RESERVED_1              =   60
QC_SERIAL_NO               =   61
QC_DEV_ID                  =   62
QC_PRODUCT_CODE            =   63
STATS_BLOCK_SIZE           = 2500
WPF_YIELD                  =    1
WPF_NETBIOS_CMDS           =    2
WPF_SET_PROTOCOL           =    4
SRWP_FLAGS                 = WPF_YIELD
NETWORK_NAME_SIZE          =   64
ASL_PARAMS_SIZE            =    4
ASL_RESPONSE_SIZE          =   22

;*****************  Access Sub license Op Code  *****************
ASL_OPEN                   =    0
ASL_CLOSE                  =    1
ASL_GET_INFO               =    2

;******************  Following are transport type identifiers  **************
XP_FIRST                   =   0            ;* Matches 1st entry.
XP_DEFAULT                 =   0            ;* Chosen by client lib.
XP_IPX                     =   1            ;* IPX/SPX                         *
XP_PIPES                   =   2            ;* Named Pipes
XP_NBIOSN                  =   3            ;* NetBIOS (NETAPI)
XP_NBIOSA                  =   4            ;* NetBIOS (NB30 via ACSNETB)
XP_LOCAL                   =   5            ;* Local server
XP_LAST                    =   5            ;* Matches last entry
XP_TERMINATOR              = 255            ;* Input-terminator for partially
                                            ;*       filled-in array
XP_UNUSED                  = 255            ;* Response-unused array element
XP_SKIP                    =   0            ;* Internal use-unsed array element
PROTOCOL_ARRAY_SIZE        =  16            ;* Size of protocols in RNBO_PARMS
RBP_USE_HARDWIRED_PPORTS   =   1            ;* Use parallel port addrs
                                            ;* defined by the library
RBP_USE_SPECIFIED_PPORTS   =   2            ;* Use parallel port addrs
                                            ;* as specified by parms
RBP_DEFINE_DEPARTMENT_NAME =   3            ;* Define department name
                                            ;* to access specific servers
RBP_USE_MAX_SERVERS        =   4            ;* Use to limit the number
                                            ;* of servers searched per
                                            ;* IPX and NetBIOS transports
RBP_DEFINE_PROTOCOLS       =   5            ;* Set client protocols from
                                            ;* array protocols.
SERVER_NAME_SIZE           =   9



;***************************************************************************
;*                           structure section                             *
;***************************************************************************

SetMax  macro   m, v
        ifndef  m
                m =  v
        else
            if  m LT v
                m =  v
            endif
        endif
        endm

C_CMD_BLOCK STRUC
COMMAND         dw ?
CELL_ADDRESS    dw ?
CELL_DATA       dw ?
C_CMD_BLOCK ENDS

QUERY_DATA  UNION
qData           db QUERY_DATA_SIZE dup(?)
C		C_CMD_BLOCK	<>
QUERY_DATA  ENDS


KEY_INFO_BLOCK STRUC
max_clients    dw ?                         ;* maximum number of open handles
                                            ;* 0 for unlimited handles
client_count   dw ?                         ;* currently opened handles
locked         dw ?                         ;* flag to indicate locked
time_out_ticks dd ?
KEY_INFO_BLOCK ENDS


STATS_BLOCK    STRUC
stats_data     db STATS_BLOCK_SIZE dup(?)
STATS_BLOCK    ENDS

RNBO_PARAMETERS_T STRUC
rnbo_func       dw ?
p2              db PROTOCOL_ARRAY_SIZE dup(?)
RNBO_PARAMETERS_T ENDS

ASL_PARAMS STRUC
asl_command     dw ?
asl_sublicense  dw ?
ASL_PARAMS ENDS

ASL_RESPONSE STRUC
asr_sublicense            dw ?
asr_present_total         dd ?
asr_present_inuse_by_all  dd ?
asr_present_inuse_by_you  dd ?
asr_missing_inuse_by_all  dd ?
asr_missing_inuse_by_you  dd ?
ASL_RESPONSE ENDS


