PAGE	59,132
TITLE	 Proteq-Emulator:VxD , (c)1999 by MeteO
.XLIST
;
;	  								  
;   			  Proteq Emulation kernel			  
;	  			Platform Q				  
;   Created: 14.09.99 22:51                 			  
;   Version: 0.00.000 (work release)		   		      	  
;   Copyright (C) 1996-99 MeteO (meteo@null.net)			  
;   This is the dongle emulation microkernel for all Proteq(tm) progs	  
;	  								  
;   We assumes no responsibility for any side-effect of using this code 
;	  								  
;   This code is privateware, do not redistribute!			  
;	  								  
;
.586p
.LIST
;
;
$Progname		Equ	'VxD/32'
Copyright		Equ     '(x)1998-99 by MeteO //UCLabs'
$ver$			Equ	'3.00.507'
;
;
.MODEL FLAT, StdCall
LOCALS
	.XLIST
	INCLUDE w32.Inc
	INCLUDE	misc.inc
	.LIST
;
;                   E Q U A T E S
; Internal driver version
VER_MAJ			EQU	3
VER_MIN			EQU	01
; Which API of Proteq is Emulated
PROTEQ_VER_MAJ		EQU	3
PROTEQ_VER_MIN		EQU	81h
;
DEVICE_ID		EQU	3CDCH
;
;
;        V I R T U A L   D E V I C E   D E C L A R A T I O N
;
;
_DATA		SEGMENT PUBLIC 'DATA' USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
; The VxD services provided for other VxDs to call
;
PUBLIC PROTEQ_DDB
PROTEQ_DDB		dd	0
__SDK_Version		dw	400h
__Req_Device_Number	dw	DEVICE_ID
__Dev_Major_Version	db	VER_MAJ
__Dev_Minor_Version	db	VER_MIN
__Flags			dw	0
__Name			db	'PROTEQ  '
__Init_Order		dd	UNDEFINED_INIT_ORDER
__Control_Proc		dd	offset Proteq_Control
__V86_API_Proc		dd	offset ProteqEmu_VM86
__PM_API_Proc		dd	offset ProteqEmu_PM0
__V86_API_CSIP		dd	0
__PM_API_CSIP		dd	0
__Reference_Data	dd	?
__Service_Table_Ptr	dd	0
__Service_Table_Size	dd	0
__Win32_Service_Table	dd	0
__Prev			dd	'Prev'
__Size			dd	size VxD_Desc_Block+1
__Reserved1		dd	'Rsv1'
__Reserved2		dd	'Rsv2'
__Reserved3		dd	'Rsv3'
;
_DATA ENDS
;
_TEXT		SEGMENT PUBLIC 'CODE' USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
;
;   P R O T E C T E D   M O D E   I N I T I A L I Z A T I O N   C O D E
;
;
;
;
;   PROCEDURE: Proteq_Control
;
;   DESCRIPTION:
;    Device control procedure for the DongleEmu VxD
;
;   ENTRY:
;    EAX = Control call ID
;
;   EXIT:
;    If carry clear then
;        Successful
;    else
;        Control call failed
;
;   USES:
;    EAX, EBX, ECX, EDX, ESI, EDI, Flags
;
;
BeginProc Proteq_Control
    Control_Dispatch CREATE_VM,			ProteqEmu_Create_VM
    Control_Dispatch VM_INIT,			ProteqEmu_VM_Init
    Control_Dispatch THREAD_INIT,		ProteqEmu_Thread_Init
    Control_Dispatch INIT_COMPLETE,		ProteqEmu_Init_Complete
    Control_Dispatch W32_DEVICEIOCONTROL,	ProteqEmu_DeviceIOControl
    Control_Dispatch SYS_DYNAMIC_DEVICE_INIT,	ProteqEmu_Dynamic_Init
    Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT,	ProteqEmu_Dynamic_Exit
    clc
    ret
EndProc Proteq_Control
;
;
;          M O V E A B L E   C O D E   S E G M E N T
;
;
BeginProc ProteqEmu_Get_Version
		mov	eax, VER_MAJ shl 4h + VER_MIN	; Get internal version
		clc
		ret
EndProc ProteqEmu_Get_Version
;---------------------------------------------------------------------------;
;
;   DESCRIPTION: This function is called to perform Device IO
;	for a 32 bit process which has opened this device with <f CreateFile>,
;	and is performing IO using <f DeviceIOControl>. Preserves the C32
;	calling registers ESI, EDI, but not EBX, since the DevIOCtl calls
;	preserve that already.
;
;   ENTRY: EBX	DDB
;	   ECX	dwIoControlCode
;	   ESI	ptr to DIOCParams
;
;   EXIT:  As determined by function, or 1 if invalid IOCTL
;---------------------------------------------------------------------------;
BeginProc ProteqEmu_DeviceIOControl
		mov	eax, [esi.DIOCParams.dwIoControlCode]
		cmp	ax, 1		
		ja	short @ccheck	
		jmp	ds:jmp_tableCC[eax*4]
; 
@critical_section:			
		mov	ecx, 0		
		VMMCall	Begin_Critical_Section
		mov	edi, [esi.DIOCParams.lpvInBuffer]
		call	MainCode
		mov	[edi], eax
		VMMCall	End_Critical_Section
@eax_0_quit:				
		xor	eax, eax	; Insert Baby Dry into Dongle
		clc			; Be always dry & healthfull...
		ret
; 
	@ccheck:				
		mov	eax, [esi.DIOCParams.dwIoControlCode]
		cmp	eax, -1
		jz	short @eax_0_quit
		mov	eax, 1
		stc	
		ret
EndProc ProteqEmu_DeviceIOControl
;
;
jmp_tableCC	dd	offset	@eax_0_quit
		dd	@critical_section
;
;
BeginProc ProteqEmu_PM0
		clc
		ret
EndProc ProteqEmu_PM0
;
;
BeginProc ProteqEmu_Old_API_Support
		clc
		ret
EndProc ProteqEmu_Old_API_Support
;
;
;
; Control procedures dispatch block
;
;
;
BeginProc ProteqEmu_Thread_Init
BeginProc ProteqEmu_VM_Init
BeginProc ProteqEmu_Init_Complete
BeginProc ProteqEmu_Create_VM
		clc
		ret
EndProc ProteqEmu_Create_VM
EndProc ProteqEmu_Init_Complete
EndProc ProteqEmu_VM_Init
EndProc ProteqEmu_Thread_Init
;
;
; Startup initialisation of Dongle emulator. Called 1 times
;
;
BeginProc ProteqEmu_Dynamic_Init
IFDEF DEBUGGING
		push	offset m_Ver
		call	DebugString
		push	offset msg_FROMAUTHORS
		call	DebugString
ENDIF
		push	eax		; Hook Int2f for system call
		push	esi
		mov	eax, 2Fh
		mov     esi, offset Int2F
		VMMCall Hook_V86_Int_Chain
		pop     esi
		pop     eax
		ret
EndProc ProteqEmu_Dynamic_Init
;
BeginProc ProteqEmu_Dynamic_Exit
		push	eax
		push	esi
		mov	eax, 2Fh
		mov     esi, offset Int2F
		VMMCall Unhook_V86_Int_Chain
		pop     esi
		pop     eax
;
BeginProc ProteqEmu_VM86			; While not supported
		mov	eax, VXD_SUCCESS
		clc
		ret
EndProc ProteqEmu_VM86
;
EndProc ProteqEmu_Dynamic_Exit
;
include func.inc
;
;
; Version check at 2F, return release version and magic number
;***
BeginProc Int2F
		cmp	[ebp.Client_EAX], 5001h ; our VXD magic func #1
		jz	@service5001
               	stc
                ret
@service5001:
                mov     [ebp.Client_EAX], VER_MAJ * 100 + VER_MIN
       	        mov     [ebp.Client_EBX], 'KCUF'; Return what we think
                mov     [ebp.Client_ECX], ' EHT'; about HASP
       	        mov     [ebp.Client_EDX], 'TORP'
IFNDEF REGISTERED
                mov     [ebp.Client_EDI], 'DEMO'
ELSE
		mov     [ebp.Client_EDI], 'REG.'
ENDIF
               	clc
               	ret
EndProc Int2F
;
BeginProc _EMUBreak
		int 3
		ret
EndProc _EMUBreak
;
_TEXT ENDS
;
; Data
;
;
_DATA		SEGMENT PUBLIC USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
IFDEF DEBUGGING
include debugng.inc
ENDIF
;
;
m_Herald		db	13,10, ''
m_Ver			db	$Progname
			db	' v', $ver$
IFNDEF REGISTERED
			db	'trial'
ENDIF
                        db	' ', Copyright, 0
			db	'(',??date,' ',??time,')'
IFNDEF NOSTRINGS
			db	'(DEBUG)'
ENDIF
;
crc_01e label byte
;
msg_FROMAUTHORS	db	0dh,0ah,0dh,0ah, 'Proteq is a *DUMB* key. '
		db	'Contact with us: <meteo@null.net>',0dh,0ah,0dh,0ah
		db	'(c)1998-1999, PRIVATE PROPERTY OF //UCL, USE WITH PERMISSION!',0dh,0ah,0dh,0ah,0
t_Herald	equ	$-m_Herald
;
;
;
;
_DATA ENDS
                end Proteq_Control

