/*--------------------------------------------------------------*/
/*          SproDump - Sentinel SuperPro Dongle dumper          */
/*--------------------------------------------------------------*/
/* Compile: lcc -c -IF%LCC_INC_DIR% -O sprodump.c               */
/*          lclnk -s -subsystem console -o sprodump.exe \       */
/*                sprodump.obj tcconio.lib                      */
/*                                                              */
/* History:                                                     */
/*   0.1   09/00   +Spath.    first Win9x version.              */
/*   0.2   10/00   +Spath.    added write password recovery     */
/*                            and cell type identification.     */
/*--------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <windowsx.h>
#include "./sprodump.h"

/* Text */
char Intro[]           = "\nSproDump v 0.2 - coded by +Spath. (10/00)\n";
char ImportsOK[]       = "\n[> Dongle functions imported";
char InitializedOK[]   = "\n[> Dongle %04X initialized";
char NoDevID[]         = "\n[> No DevID specified.\n";
char TestDevID[]       = "\r[> Testing Dongle ID: %04X";
char TestWritePW[]     = "\r[> Testing WritePassword: %04X";
char PWSearchAborted[] = "\n[> No unused cell, WritePW search aborted";
char WritePWis[]       = "\r[> Write Password: %04X       \n";

/* Imports */
char SproDriver[]            = "\\\\.\\SENTINEL.VXD";
char SproLibrary[]           = "SX32W.DLL";
char RNBOsproInitialize[]    = "RNBOsproInitialize";
char RNBOsproFormatPacket[]  = "RNBOsproFormatPacket";
char RNBOsproFindFirstUnit[] = "RNBOsproFindFirstUnit";
char RNBOsproQuery[]         = "RNBOsproQuery";
char RNBOsproRead[]          = "RNBOsproRead";
char RNBOsproExtendedRead[]  = "RNBOsproExtendedRead";
char RNBOsproWrite[]         = "RNBOsproWrite";

/* Superpro functions */
HANDLE  SproDriverHandle;
HINSTANCE SproLibHandle;
FARPROC SproInit;
FARPROC SproFormatPacket;
FARPROC SproFindFirstUnit;
FARPROC SproQuery;
FARPROC SproRead;
FARPROC SproXRead;
FARPROC SproWrite;

/* Superpro variables */
RB_SPRO_APIPACKET ApiPacket;
UNITINFO  InitialUI;
int   Status;
long  DevID;
int   QueryData[100];
int   QueryResult[100];
int   QueryResult32[100];
int   ReadData;
int   AccessCode;
int   WritePW = 0;
int   TrialCell;
int   CellNb;
int   AccessCode;
BOOL  WritePWOption = FALSE;
char  OutputFileName[20] = "spro.dmp";
FILE* OutputFile;

/*-----------------------------------------------------------------------*/
/* Start of Code - Start of Code - Start of Code - Start of Code - Start */
/*-----------------------------------------------------------------------*/
/*----------------*/
/* User Interface */
/*----------------*/
void HandleOptions(int argc,char *argv[])
{
 int i;

 for (i=1; i< argc;i++) {
    if (argv[i][0] == '/' || argv[i][0] == '-') {
       switch (argv[i][1]) {
          case 'w':
             WritePWOption=TRUE;
             break;
          case '?':
          case 'h':
          case 'H':
          default:
             printf("\nUsage: sprodump <DevID> ");
             printf("\n       sprodump -w <DevID> : guess also Write Password\n");
             exit(0);         
       }
    }
    else {
          DevID=strtol(argv[i],0,16);
          break;
         }
    }
}

/*--------------------*/
/* Imports Resolution */
/*--------------------*/
void GetDongleImports() {
    /* Load Sentinel Driver */
    if ((SproDriverHandle=CreateFileA(SproDriver,0xC0000000,3,0,3,
         0x40000000,0)) == 0) {
       printf("\nCannot find %s\n",SproDriver);
    }

    /* Get Sentinel DLL handle */
    if ((SproLibHandle=LoadLibraryA(SproLibrary)) == 0) {
       printf("\nCannot find %s\n",SproLibrary);
       exit(1);
    }

    /* Get Functions addresses */
    if ((SproInit=GetProcAddress(SproLibHandle,RNBOsproInitialize))==0) {
       printf("\nCannot find %s\n",SproInit);
       exit(1);
    }

    if ((SproFormatPacket=GetProcAddress(SproLibHandle,RNBOsproFormatPacket))==0) {
       printf("\nCannot find %s\n",SproFormatPacket);
       exit(1);
    }

    if ((SproFindFirstUnit=GetProcAddress(SproLibHandle,RNBOsproFindFirstUnit))==0) {
       printf("\nCannot find %s\n",SproFindFirstUnit);
       exit(1);
    }

    if ((SproQuery=GetProcAddress(SproLibHandle,RNBOsproQuery))==0) {
       printf("\nCannot find %s\n",SproQuery);
       exit(1);
    }

    if ((SproRead=GetProcAddress(SproLibHandle,RNBOsproRead))==0) {
       printf("\nCannot find %s\n",SproRead);
       exit(1);
    }

    if ((SproXRead=GetProcAddress(SproLibHandle,RNBOsproExtendedRead))==0) {
       printf("\nCannot find %s\n",SproXRead);
       exit(1);
    }

    if ((SproWrite=GetProcAddress(SproLibHandle,RNBOsproWrite))==0) {
            printf("Cannot find %s\n",SproWrite);
        exit(1);
    }
    printf(ImportsOK);
}

/*-----------------------*/
/* Dongle Initialisation */
/*-----------------------*/
void InitializeDongle() {
    (* SproFormatPacket)(&ApiPacket,sizeof(ApiPacket));
    if ((Status=(* SproInit)(&ApiPacket))!=0) {
        printf("\nError initializing Device : %04X \n", Status);
        exit(1);
    }

    if ((Status=(* SproFindFirstUnit)(&ApiPacket,DevID))!=0) {
        printf("\nError: No Device found with DevID %04X \n", DevID);
		exit(1);
    }
    printf(InitializedOK,DevID);
}

/*-------------------------------*/
/* Unknown Dongle Initialization */
/*-------------------------------*/
void InitializeUnknownDongle() {
    (* SproFormatPacket)(&ApiPacket,sizeof(ApiPacket));
    if ((Status=(* SproInit)(&ApiPacket))!=0) {
       printf("\nError initializing Device : %i \n", Status);
       exit(1);
    }

    printf(NoDevID);
    DevID = 0;
    Status=0xffff;
    /* bruteforce DevID (16 bits value) */
    while (Status!=0) {
       Status=(* SproFindFirstUnit)(&ApiPacket,DevID);
       printf(TestDevID, DevID);
       DevID++;
    }
    DevID--;
    printf(InitializedOK,DevID);
}

/*---------------------*/
/* Find Write password */
/*---------------------*/
void FindWritePassword(int TestCell) {
    WritePW = 0;
    Status=0xffff;
    Status = (* SproXRead)(&ApiPacket,TestCell,&ReadData,0);

    /* bruteforce password (16 bits value) */
    while (Status!=0) {
       Status = (* SproWrite)(&ApiPacket,WritePW,TestCell,ReadData,0);
       printf(TestWritePW, WritePW);
       WritePW++;
    }
    printf(WritePWis,(WritePW-1));
}

/*-------------------*/
/* Prepare Dump File */
/*-------------------*/
void OpenDumpFile() {
   if (!(OutputFile = fopen(OutputFileName,"w+"))) {
       printf("\nError: cannot write %s", OutputFileName);
       exit(1);
   }
}

/*-------------*/
/* Dongle Dump */
/*-------------*/
void DongleDump() {
    TrialCell=0;
    OpenDumpFile();
    printf("\n[> Dumping Dongle contents... ");

    for (CellNb=0;CellNb<64;CellNb++) {
       Status = (* SproXRead)(&ApiPacket,CellNb,&ReadData,&AccessCode );
       if (Status==SP_SUCCESS) {
          fprintf(OutputFile,"\nCell 0x%02X: %04X (%i/%i)", CellNb, ReadData,
                  AccessCode, Status);

          /* remember writeable cells for safe WritePW recovery */
          if ((AccessCode==0)&&(TrialCell==0)) TrialCell=CellNb;
       }
       else {
          fprintf(OutputFile,"\nCell 0x%02X: ???? (%i/%i)", CellNb,
                  AccessCode, Status);
       }

       /* handle restricted cells */
       switch(CellNb) {
          case 0 : fprintf(OutputFile," (Dongle Serial Number)");
                   break;
          case 1 : fprintf(OutputFile," (Developer ID)");
                   break;
          case 2 : fprintf(OutputFile," (OverWrite Password 1)");
                   break;
          case 3 : fprintf(OutputFile," (OverWrite Password 2)");
                   break;
          case 4 : fprintf(OutputFile," (Write Password)");
                   break;
          case 5 : 
          case 6 : 
          case 7 : fprintf(OutputFile," (Reserved Cell)");
       }

       if (CellNb>=8) {
          /* differentiate active/inactive algorithm cells by querying them */
          if ((CellNb%2==0)&&((AccessCode==3)||(Status==4))) {
             QueryData[0]=0x1234;
             QueryData[1]=0x5678;
             Status = (* SproQuery)(&ApiPacket,CellNb,&QueryData,&QueryResult,
                                    &QueryResult32, 2);
             if ((QueryData[0]!=QueryResult[0])&&(QueryData[1]!=QueryResult[1])) 
                fprintf(OutputFile," (Active Algorithm)");
             else
                fprintf(OutputFile," (Inactive Algorithm)");
          }
          if (AccessCode==2) fprintf(OutputFile," (Counter cell)");
          if (AccessCode==1) fprintf(OutputFile," (Read Only Data)");
       }
    }
    fclose(OutputFile);
    printf("done.\n");
}

/*-----------------------------------------------------------------------*/
/* Main - Main - Main - Main - Main - Main - Main - Main - Main - Main - */
/*-----------------------------------------------------------------------*/
int main(int argc,char *argv[])
{
    printf(Intro);
    HandleOptions(argc,argv);       
    GetDongleImports();

    if (DevID==0)
       InitializeUnknownDongle();
    else
       InitializeDongle();

    DongleDump();

    if (WritePWOption) {
       if (TrialCell==0) printf(PWSearchAborted);
       else FindWritePassword(TrialCell);
    }

    printf("Thank you...\n");
    return(0);
}
