/* SPRODUMP.H - light version of SuperPro.h */

/* Superpro structures */
typedef struct {
  unsigned short developerID;     /* unit's developer ID                  */
  unsigned short serialNumber;    /* serial number                        */
  unsigned short port;            /* port address used by the key         */
  unsigned char  reserved[18];    /* reserved area (for internal use)     */
} UNITINFO;

typedef struct {
  unsigned char  functionCode;    /* Function code                        */
  unsigned char  intMode;         /* Method for disabling interrupts      */
  unsigned short portAddrs[4];    /* addresses of port LPT1 - LPT4        */
  unsigned char  reserved1[10];   /* reserved for internal use            */
  unsigned short delay5usec;      /* loops to make at least 5 microsecond */
  unsigned short delay100usec;    /* loops to make at least 100 microsecon*/
  UNITINFO       ui;              /* current unit information             */
  /* . . . . . . . . . . command specific variables . . . . . . . . . . . */
  unsigned short writePassword;   /*                                      */
  unsigned short xtraPassword1;   /*                                      */
  unsigned short xtraPassword2;   /*                                      */
  unsigned short memoryAddress;   /*                                      */
  unsigned short memoryContents;  /*                                      */
  unsigned char  status;          /* Status value returned from driver    */
  unsigned char  accessCode;      /*                                      */
  unsigned long  QueryIn;         /*                                      */
  unsigned long  QueryOut;        /*                                      */
  unsigned long  longResult;      /*                                      */
  unsigned short dataLength;      /*                                      */
  unsigned char  InitialPICMask1; /* PIC mask 1 for API_INITIALIZE only   */
  unsigned char  InitialPICMask2; /* PIC mask 2 for API_INITIALIZE only   */
  unsigned short cmd;             /* Set/Get config information           */
  unsigned short func;            /* opcode indicating the parameter      */
  unsigned long  params;          /* parameter data                       */
  unsigned char  reserved2[20];   /*                                      */
  unsigned char  reserved3[516];  /*                                      */
} APIPACKET;

                                     /* for dword alignment roll-up      */
#define SPRO_APIPACKET_ALIGNMENT_VALUE (sizeof(unsigned long))
#define SPRO_APIPACKET_SIZE            (1024+SPRO_APIPACKET_ALIGNMENT_VALUE)
#define SPRO_MAX_QUERY_SIZE            56              /* in bytes         */

/**  SuperPro API error codes.  **/
#define SP_SUCCESS                      0
#define SP_INVALID_FUNCTION_CODE        1
#define SP_INVALID_PACKET               2
#define SP_UNIT_NOT_FOUND               3
#define SP_ACCESS_DENIED                4
#define SP_INVALID_MEMORY_ADDRESS       5
#define SP_INVALID_ACCESS_CODE          6
#define SP_PORT_IS_BUSY                 7
#define SP_WRITE_NOT_READY              8
#define SP_NO_PORT_FOUND                9
#define SP_ALREADY_ZERO                 10
#define SP_DRIVER_OPEN_ERROR            11
#define SP_DRIVER_NOT_INSTALLED         12
#define SP_IO_COMMUNICATIONS_ERROR      13
#define SP_PACKET_TOO_SMALL             15
#define SP_INVALID_PARAMETER            16
#define SP_MEM_ACCESS_ERROR             17
#define SP_VERSION_NOT_SUPPORTED        18
#define SP_OS_NOT_SUPPORTED             19
#define SP_QUERY_TOO_LONG               20
#define SP_INVALID_COMMAND              21
#define SP_MEM_ALIGNMENT_ERROR          29
#define SP_DRIVER_IS_BUSY               30
#define SP_PORT_ALLOCATION_FAILURE      31
#define SP_PORT_RELEASE_FAILURE         32
#define SP_ACQUIRE_PORT_TIMEOUT         39
#define SP_SIGNAL_NOT_SUPPORTED         42
#define SP_UNKNOWN_MACHINE              44
#define SP_SYS_API_ERROR                45
#define SP_UNIT_IS_BUSY                 46
#define SP_INVALID_PORT_TYPE            47
#define SP_INVALID_MACH_TYPE            48
#define SP_INVALID_IRQ_MASK             49
#define SP_INVALID_CONT_METHOD          50
#define SP_INVALID_PORT_FLAGS           51
#define SP_INVALID_LOG_PORT_CFG         52
#define SP_INVALID_OS_TYPE              53
#define SP_INVALID_LOG_PORT_NUM         54
#define SP_INVALID_ROUTER_FLGS          56
#define SP_INIT_NOT_CALLED              57
#define SP_DRVR_TYPE_NOT_SUPPORTED      58
#define SP_FAIL_ON_DRIVER_COMM          59


/* Define possible driver types (Not used refer to Driver Types). */
#define SP_DRVR_WIN31             4
#define SP_DRVR_WINNT             5


typedef                void  RB_VOID;
typedef unsigned       char  RB_BOOLEAN;
typedef unsigned       char  RB_BYTE;
typedef unsigned short int   RB_WORD;
typedef unsigned long  int   RB_DWORD;

typedef RB_DWORD RB_SPRO_APIPACKET[SPRO_APIPACKET_SIZE/sizeof(RB_DWORD)];
typedef RB_WORD  SP_STATUS;

/**  SuperPro API functions.  **/
#define API_INITIALIZE          0
#define API_FIND_FIRST_UNIT     1
#define API_FIND_NEXT_UNIT      2
#define API_READ                3
#define API_EXTENDED_READ       4
#define API_WRITE               5
#define API_OVERWRITE           6
#define API_DECREMENT           7
#define API_ACTIVATE_ALGORITHM  8
#define API_QUERY               9
#define API_GET_VERSION         11
#define API_GET_EXTENDED_STATUS 12
#define API_CONFIG              13

/*
 SuperPro configuration's cmd values to SET or GET library parameters
*/
#define SPD_GET_LIB_PARAMS_CMD 0
#define SPD_SET_LIB_PARAMS_CMD 1
#define SPD_DRVR_FLAGS_FUNC    0
#define SPD_HW_TYPE_FUNC       1
#define SPD_PORT_FUNC          2
#define SPD_PIC_FUNC           3
#define SPD_HW_AUTO_DETECT     0
#define SPD_HW_TYPE_IBM        1
#define SPD_HW_TYPE_NEC        2
#define SPD_HW_TYPE_FMR        4
#define SPD_USE_LINKED_DRVR 0x20
#define SPD_USE_SYSTEM_DRVR 0x40
#define SPD_PORT_1             0
#define SPD_PORT_2             1
#define SPD_PORT_3             2
#define SPD_PORT_4             3
#define SPD_PIC_1              0
#define SPD_PIC_2              1

#define USE_STI_CLI                     0X01
#define USE_PIC_REGS                    0X02
#define USE_WIN_CRITICAL                0X04

#define DEFAULT_PORT_ADDRESS1   0x0
#define DEFAULT_PORT_ADDRESS2   0x0
#define DEFAULT_PORT_ADDRESS3   0x0
#define DEFAULT_INT_METHODS             (USE_PIC_REGS | USE_WIN_CRITICAL | SPD_USE_LINKED_DRVR | SPD_USE_SYSTEM_DRVR)
#define DEFAULT_PIC_MASK1               0X81    /* Mask Timer Tick & Printer */
#define DEFAULT_PIC_MASK2               0X00    /* Don't mask any            */


#define ACCESS_CODE_ALGO 0x3
