//----------------------------------------------------------------------
//
// support address meteo@null.net
//
//----------------------------------------------------------------------
//----------------------------------------------------------------------
//
// HASP emulator for Windows NT 4.0, (x)1998-99 by MeteO, Fixit
// Private property of //UCL
//
// (based on code of TechMick & kab)/Totally reworked
//
// Created: 24.08.98 22:54/Rewritten 24.07.99
//----------------------------------------------------------------------
#define REGISTERED 1
//
#define version "3.00.507"
#include "stdarg.h"
#include "stdio.h"
#include "memory.h"
#include <hasp.h>
#include <haspnt.h>
#include <debug.h>
#include <registry.h>
//----------------------------------------------------------------------
//                         GLOBALS
//----------------------------------------------------------------------

//
// This is HaspEMU's user-inteface device object. It is addressed
// by calls from the GUI including CreateFile and DeviceIoControl
//

PDEVICE_OBJECT deviceObject;
PCHAR	HaspBuffer;
ULONG	HaspBufferLength;
PUSHORT	m_NetMemory;
extern	PUCHAR m_Buf;
//----------------------------------------------------------------------
//
//   Path to service node key
//
//----------------------------------------------------------------------

#define STR_SERVICES_SUBKEY TEXT("\\Emulator\\HASP")
//
#define STR_DEVNAME	(L"\\Device\\Hasp")
#define STR_DEDOSVNAME	(L"\\DosDevices\\hasp")
//----------------------------------------------------------------------
//
// DriverEntry
//
// Installable driver initialization. Here we just set ourselves up.
//
// This routine will handle the initialization of this driver. There is
// not a lot of code required other than to initialize the device object
// and extension, then return.
//
//----------------------------------------------------------------------
NTSTATUS DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath )
{
    NTSTATUS                ntStatus;
    WCHAR                   deviceNameBuffer[]  = STR_DEVNAME;
    UNICODE_STRING          deviceNameUnicodeString;
    WCHAR                   deviceLinkBuffer[]  = STR_DEDOSVNAME;
    UNICODE_STRING          deviceLinkUnicodeString;
    ULONG                   i;

    UNICODE_STRING		paramPath;
    RTL_QUERY_REGISTRY_TABLE    paramTable[3];
    ULONG                       zero = 0;
    PDEVICE_EXTENSION		extension;
    ULONG                       trialevel = 0;
    ULONG			SICEcheck = 0;
#ifndef REGISTERED
    static  WCHAR		SubKeyString[] = STR_SERVICES_SUBKEY;
#endif
//
//
#ifndef REGISTERED
    NTPrint ("Hasp-Emu/NT v%s.Trial, (c)1998-99 by  MeteO, Fixit //UCL",version);
#else
    NTPrint ("Hasp-Emu/NT v%s, (c)1998-99 by  MeteO, Fixit //UCL",version);
#endif

//
//
    //
    // Setup the device name
    //
    RtlInitUnicodeString (&deviceNameUnicodeString, deviceNameBuffer );
    //
    // Create the device used for GUI communications
    //
    ntStatus = IoCreateDevice (DriverObject,
                               0,
                               &deviceNameUnicodeString,
                               FILE_DEVICE_UNKNOWN,
                               0,
                               TRUE,
                               &deviceObject );

 //
 // Create dispatch points for all routines that must be handled.
 // All entry points are registered since we might filter a
 // file system that processes all of them.
 //
	
    extension = deviceObject->DeviceExtension;
    RtlZeroMemory(extension, sizeof(DEVICE_EXTENSION));
    extension->DeviceObject = deviceObject;

    // Initialize an empty work queue.

    extension->CurrentIrp = NULL;
    KeInitializeSpinLock(&extension->ControlLock);

    DriverObject->MajorFunction[IRP_MJ_CREATE]          	= HASP_SWITCHER;
    DriverObject->MajorFunction[IRP_MJ_CLOSE]           	= HASP_SWITCHER;
    DriverObject->MajorFunction[IRP_MJ_READ]            	= HASP_SWITCHER;
    DriverObject->MajorFunction[IRP_MJ_WRITE]           	= HASP_SWITCHER;
    DriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL]  	= HASP_SWITCHER;
    DriverObject->MajorFunction[IRP_MJ_INTERNAL_DEVICE_CONTROL]	= HASP_SWITCHER;
    DriverObject->DriverStartIo					= HASP_EMULATOR;
    DriverObject->DriverUnload                          	= HASP_UNLOAD;
 //
 // If successful, make a symbolic link that allows for the device
 // object's access from Win32 programs
 //
    RtlInitUnicodeString (&deviceLinkUnicodeString, deviceLinkBuffer );

    ntStatus = IoCreateSymbolicLink (&deviceLinkUnicodeString, &deviceNameUnicodeString );


    //
    // If something went wrong, cleanup the device object and don't load
    //

    if (!NT_SUCCESS(ntStatus))
	{

            NTPrint ("IoCreateSymbolicLink failed");
	    NTPrint ("Failed to create our device!");

            if( deviceObject )
        	{
		IoDeleteDevice(DriverObject->DeviceObject);
        	}
	return (STATUS_UNSUCCESSFUL);
        }
	else
	    NTPrint ("IoCreateSymbolicLink success");

#ifndef REGISTERED
    CheckRegistered();
#endif
    InstallInt06();

    //
    // Read registry dumps
    //
    ntStatus = FirstInit();

    if (!NT_SUCCESS(ntStatus))
    {

        NTPrint("Failed to create our device!");
	HASP_UNLOAD(DriverObject);
	return (STATUS_REGISTRY_IO_FAILED);
    };
    return ntStatus;
}
//----------------------------------------------------------------------
//
// HASP_Unload
//
// Our job is done - time to leave.
//
//----------------------------------------------------------------------
NTSTATUS HASP_UNLOAD( IN PDRIVER_OBJECT DriverObject )
{
    WCHAR                  deviceLinkBuffer[]  = STR_DEDOSVNAME;
    UNICODE_STRING         deviceLinkUnicodeString;
    RestoreInt06();
    FreeDumpMemory();
    //
    // Delete the symbolic link for our GUI device
    //
    RtlInitUnicodeString( &deviceLinkUnicodeString, deviceLinkBuffer );
    IoDeleteSymbolicLink( &deviceLinkUnicodeString );

    NTPrint("Starting unloading sequence");

    //
    // Delete the device object, making sure that the GUI device
    // object is always deleted.
    //
    IoDeleteDevice( DriverObject->DeviceObject );

    NTPrint("Device deleted");

    return(STATUS_SUCCESS) ;
}
//----------------------------------------------------------------------
//
//
// Routine Description:
//
//  This routine is used to cancel any request in the driver.
//
// Arguments:
//
//    DeviceObject - Pointer to the device object for this device
//
//    Irp - Pointer to the IRP to be canceled.
//
// Return Value:
//
//    None.
//
//----------------------------------------------------------------------

VOID CancelFunction( IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp )
{

    //
    // If this is the current request then just let normal
    // code detect that the current is cancelled.
    //
    // If this isn't the current request then remove the request
    // from the device queue and complete it.
    //

    if (Irp != DeviceObject->CurrentIrp) {

        KeRemoveEntryDeviceQueue(
            &DeviceObject->DeviceQueue,
            &Irp->Tail.Overlay.DeviceQueueEntry
            );

        Irp->IoStatus.Status = STATUS_CANCELLED;
        Irp->IoStatus.Information = 0;

        IoReleaseCancelSpinLock(Irp->CancelIrql);

        IoCompleteRequest(Irp, IO_NO_INCREMENT);

    } else {

        IoReleaseCancelSpinLock(Irp->CancelIrql);

    }

}
//----------------------------------------------------------------------
NTSTATUS HASP_SWITCHER( IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp )
{
//    NTPrint("Hasp_Switcher");

//------------------------------------------------------------------
//    __asm	int 3

//    __asm	int 3
//------------------------------------------------------------------



Irp->IoStatus.Information=0;

switch ( Irp->Tail.Overlay.CurrentStackLocation->MajorFunction)
{
	case 	IRP_MJ_READ 			:
	case    IRP_MJ_DEVICE_CONTROL 		:
		{
			IRP_READ_AND_DIOC(DeviceObject,Irp);
			break;
		}
	case	IRP_MJ_INTERNAL_DEVICE_CONTROL 	:

		{
			break;
		}
	default					:
		{

			IoCompleteRequest(Irp, IO_NO_INCREMENT);
			break;
		}
}
	return(STATUS_SUCCESS) ;
}
//----------------------------------------------------------------------
NTSTATUS IRP_READ_AND_DIOC(IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp)
{
	HaspBuffer=Irp->UserBuffer;
	if(Irp->Tail.Overlay.CurrentStackLocation->Parameters.Read.Length>=0x28)
		{
		HaspBufferLength=Irp->Tail.Overlay.CurrentStackLocation->Parameters.Read.Length;
		IoStartPacket(DeviceObject,Irp,NULL,CancelFunction);
                }else
		{
		HaspBuffer[4]=(UCHAR) 0xD8;
		IoCompleteRequest(Irp, IO_NO_INCREMENT);
		}

	return(STATUS_SUCCESS) ;
}
//----------------------------------------------------------------------
NTSTATUS HASP_EMULATOR( IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp )
{
    NTPrint ("Entering Emu, Buffer length is %2.2lx bytes",HaspBufferLength);
 	switch(HaspBufferLength){
 	 case 0x48:
		{
			__asm
			{
				push	ebp
				mov	ebp, HaspBuffer
                                call	Buffer0x48
				pop	ebp
			}
			break;
		}
	 case 0x54:
		{
			__asm{
				push	ebp
				mov	ebp, HaspBuffer
                                call	Buffer0x54
				pop	ebp
				}

			break;
		}
	 case 0x28:
		{
			__asm
                        	{
				push	ebp
                                mov	ebp, HaspBuffer
                                call	Buffer0x28
				pop	ebp
                                };
			break;
		}
	 default:
	  {
	   NTPrint ("Buffer Length is not supported");
	   break;
	  }
	}
    IoStartNextPacket(DeviceObject,TRUE);
    IoCompleteRequest(Irp, IO_NO_INCREMENT);
    return(STATUS_SUCCESS);
}
