//----------------------------------------------------------------------
//
// support address meteo@null.net
//
//----------------------------------------------------------------------
#include "registry.h"

#define ADD_ALLOCATED_DUMP	0x10
#define MEMORY_MAX_LENGTH	0x200


HANDLE DumpEntryHandle,KeyDumpHandle;
OBJECT_ATTRIBUTES OA,Dump_OA;
UNICODE_STRING DUMP_ENTRY_NAME,KEY_DUMP;

UNICODE_STRING USSN,USPwd,USType,USData;


PWSTR RegistryPath= L"\\Registry\\MACHINE\\System\\CurrentControlSet\\Services\\Emulator\\HASP\\Dump";
ULONG BufferLength;
int status;
ULONG i,j;
PKEY_FULL_INFORMATION KeyInfo;
PKEY_BASIC_INFORMATION DumpBasicInfo;
PKEY_VALUE_FULL_INFORMATION AnyValue;
PCHAR MemoryValue;
PCHAR CurrentDump;

//
//

NTSTATUS FirstInit(VOID)
{

RtlInitUnicodeString(&DUMP_ENTRY_NAME,RegistryPath);
RtlInitUnicodeString(&USSN,L"SN");
RtlInitUnicodeString(&USPwd,L"Pwd");
RtlInitUnicodeString(&USType,L"Type");
RtlInitUnicodeString(&USData,L"Data");
InitializeObjectAttributes(&OA,&DUMP_ENTRY_NAME,OBJ_CASE_INSENSITIVE,NULL,NULL);
status=ZwOpenKey(&DumpEntryHandle,KEY_QUERY_VALUE|KEY_SET_VALUE|KEY_ENUMERATE_SUB_KEYS,&OA);
// \HASP\DUMP is opened

if(status!=0)
	{
	 NTPrint ("Error %X while opening HASP\\DUMP registry record",status);
	 return (STATUS_REGISTRY_IO_FAILED);
	}


KeyInfo = MmAllocateNonCachedMemory(sizeof(KEY_FULL_INFORMATION)+0x80);
DumpBasicInfo = MmAllocateNonCachedMemory(sizeof(KEY_BASIC_INFORMATION)+0x80);
AnyValue = MmAllocateNonCachedMemory(sizeof(KEY_VALUE_FULL_INFORMATION)+0x500);

status=ZwQueryKey(DumpEntryHandle,KeyFullInformation,KeyInfo,sizeof(KEY_FULL_INFORMATION)+0x80,&BufferLength);

if(status==0)
	{
	 t_Supported=KeyInfo->SubKeys;
	 NTPrint ("%d dump-records was found",t_Supported);
	 if(t_Supported!=0)
	  {

	   heapSupported=MmAllocateNonCachedMemory(sizeof(Keys)*(t_Supported+ADD_ALLOCATED_DUMP));
           heapMemory=MmAllocateNonCachedMemory(MEMORY_MAX_LENGTH*(t_Supported+ADD_ALLOCATED_DUMP));
	   NTPrint ("Allocated heapMemory %p, heapSupported %p",heapMemory,heapSupported);
	   for(i=0;i<t_Supported;i++)
	    { //Reading DUMPS
		ZwEnumerateKey(DumpEntryHandle,i,KeyBasicInformation,DumpBasicInfo,
			sizeof(KEY_BASIC_INFORMATION)+0x80,&BufferLength);

		RtlInitUnicodeString(&KEY_DUMP,DumpBasicInfo->Name);

		InitializeObjectAttributes(&Dump_OA,&KEY_DUMP,OBJ_CASE_INSENSITIVE,DumpEntryHandle,NULL);

		status=ZwOpenKey(&KeyDumpHandle,KEY_QUERY_VALUE|KEY_SET_VALUE|KEY_ENUMERATE_SUB_KEYS,&Dump_OA);

		if(status!=0)
		{
		NTPrint ("Error %X while opening DUMP\\XXXX registry record",status);
		break;
		}
		//PWD
	   if(ZwQueryValueKey(KeyDumpHandle,&USPwd,KeyValueFullInformation,AnyValue,sizeof(KEY_VALUE_FULL_INFORMATION)+0x500,&BufferLength)==0)
	    {
		heapSupported[i].Pwd1=(ULONG) *((PUSHORT)(AnyValue->DataOffset+(PCHAR)AnyValue+2));
		heapSupported[i].Pwd2=(ULONG) *((PUSHORT)(AnyValue->DataOffset+(PCHAR)AnyValue+0));}
		NTPrint("Pwds %04.04lx:%04.04lx",heapSupported[i].Pwd1,heapSupported[i].Pwd2);
		//TYPE
		if(ZwQueryValueKey(KeyDumpHandle,&USType,KeyValueFullInformation,AnyValue,sizeof(KEY_VALUE_FULL_INFORMATION)+0x500,&BufferLength)==0)
		 {
		  heapSupported[i].Type=(ULONG) *((PULONG)(AnyValue->DataOffset+(PCHAR)AnyValue));

		  if(IsValidKeyType(heapSupported[i].Type)==1)
		   {
			__asm{
				pushad
				mov eax,i
				inc eax
				call GetOffsetToMem
				mov  eax,heapMemory
				add  ebx,eax
				mov  MemoryValue,ebx
				popad
			}
		   }

		  heapSupported[i].PMemory=(PSHORT)MemoryValue;
		//SERIAL
		  if(ZwQueryValueKey(KeyDumpHandle,&USSN,KeyValueFullInformation,AnyValue,sizeof(KEY_VALUE_FULL_INFORMATION)+0x500,&BufferLength)==0)
		   {
		    *(int*)(heapSupported[i].PMemory)=(ULONG) *((PULONG)(AnyValue->DataOffset+(PCHAR)AnyValue));
		   }
		//MEMORY
		  if(ZwQueryValueKey(KeyDumpHandle,&USData,KeyValueFullInformation,AnyValue,sizeof(KEY_VALUE_FULL_INFORMATION)+0x500,&BufferLength)==0)
		   {
		    for(j=0;j<(ULONG)(heapSupported[i].Type*128-16);j++)
		     {
		      (UCHAR) *((PUCHAR)(j+4+(PUCHAR)heapSupported[i].PMemory))=(UCHAR) *((PUCHAR)(AnyValue->DataOffset+j+(PCHAR)AnyValue));
		     }
		   }
                 }
		 else
		 {
       		  ZwClose(KeyDumpHandle);
       		  heapSupported[i].Pwd1=heapSupported[i].Pwd2=0;
		 }// end of Valid Key Type checking
		ZwClose(KeyDumpHandle);
	    }
	  } //End if records found
	  else
	    { NTPrint ("No record found");} //No records found
	}else{NTPrint ("Error %X while reading registry record",status);}//End if first query key;

ZwClose(DumpEntryHandle);
MmFreeNonCachedMemory(AnyValue,sizeof(KEY_VALUE_FULL_INFORMATION)+0x500);
MmFreeNonCachedMemory(KeyInfo,sizeof(KEY_FULL_INFORMATION)+0x80);
MmFreeNonCachedMemory(DumpBasicInfo,sizeof(KEY_BASIC_INFORMATION)+0x80);
return (status);
}//End setup registry;



///Release taken memory
VOID FreeDumpMemory(VOID)
{
MmFreeNonCachedMemory(heapSupported,sizeof(Keys)*(t_Supported+ADD_ALLOCATED_DUMP));
MmFreeNonCachedMemory(heapMemory,MEMORY_MAX_LENGTH*(t_Supported+ADD_ALLOCATED_DUMP));
return;
} //End of FreeDumpMemory



///Is valid keytype

int IsValidKeyType(ULONG keytype)
{
if (keytype<=4){return 1;}
return 0;
}


///Check Security
int CheckSecurity(HANDLE DumpHandle)
{
UNICODE_STRING USOwner,USExpired,USCRC,USPwd,USSN;

RtlInitUnicodeString(&USSN,L"SN");
RtlInitUnicodeString(&USPwd,L"Pwd");
RtlInitUnicodeString(&USCRC,L"CRC");
RtlInitUnicodeString(&USOwner,L"Owner");
RtlInitUnicodeString(&USData,L"Expired");

return 0;
}

void ReadRegistry(void)
{
__asm stc;
}
